// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.SingleValueLegacyExtendedProperty;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Single Value Legacy Extended Property Request.
 */
public class SingleValueLegacyExtendedPropertyRequest extends BaseRequest implements ISingleValueLegacyExtendedPropertyRequest {
	
    /**
     * The request for the SingleValueLegacyExtendedProperty
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SingleValueLegacyExtendedPropertyRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SingleValueLegacyExtendedProperty.class);
    }

    /**
     * Gets the SingleValueLegacyExtendedProperty from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super SingleValueLegacyExtendedProperty> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SingleValueLegacyExtendedProperty from the service
     *
     * @return the SingleValueLegacyExtendedProperty from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SingleValueLegacyExtendedProperty get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super SingleValueLegacyExtendedProperty> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SingleValueLegacyExtendedProperty with a source
     *
     * @param sourceSingleValueLegacyExtendedProperty the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final SingleValueLegacyExtendedProperty sourceSingleValueLegacyExtendedProperty, final ICallback<? super SingleValueLegacyExtendedProperty> callback) {
        send(HttpMethod.PATCH, callback, sourceSingleValueLegacyExtendedProperty);
    }

    /**
     * Patches this SingleValueLegacyExtendedProperty with a source
     *
     * @param sourceSingleValueLegacyExtendedProperty the source object with updates
     * @return the updated SingleValueLegacyExtendedProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SingleValueLegacyExtendedProperty patch(final SingleValueLegacyExtendedProperty sourceSingleValueLegacyExtendedProperty) throws ClientException {
        return send(HttpMethod.PATCH, sourceSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty, final ICallback<? super SingleValueLegacyExtendedProperty> callback) {
        send(HttpMethod.POST, callback, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the new object to create
     * @return the created SingleValueLegacyExtendedProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SingleValueLegacyExtendedProperty post(final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) throws ClientException {
        return send(HttpMethod.POST, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty, final ICallback<? super SingleValueLegacyExtendedProperty> callback) {
        send(HttpMethod.PUT, callback, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Creates a SingleValueLegacyExtendedProperty with a new object
     *
     * @param newSingleValueLegacyExtendedProperty the object to create/update
     * @return the created SingleValueLegacyExtendedProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SingleValueLegacyExtendedProperty put(final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) throws ClientException {
        return send(HttpMethod.PUT, newSingleValueLegacyExtendedProperty);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ISingleValueLegacyExtendedPropertyRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (SingleValueLegacyExtendedPropertyRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ISingleValueLegacyExtendedPropertyRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (SingleValueLegacyExtendedPropertyRequest)this;
     }

}

