// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.SwapShiftsChangeRequest;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Swap Shifts Change Request Request.
 */
public class SwapShiftsChangeRequestRequest extends BaseRequest implements ISwapShiftsChangeRequestRequest {
	
    /**
     * The request for the SwapShiftsChangeRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SwapShiftsChangeRequestRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SwapShiftsChangeRequest.class);
    }

    /**
     * Gets the SwapShiftsChangeRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super SwapShiftsChangeRequest> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SwapShiftsChangeRequest from the service
     *
     * @return the SwapShiftsChangeRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SwapShiftsChangeRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super SwapShiftsChangeRequest> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SwapShiftsChangeRequest with a source
     *
     * @param sourceSwapShiftsChangeRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final SwapShiftsChangeRequest sourceSwapShiftsChangeRequest, final ICallback<? super SwapShiftsChangeRequest> callback) {
        send(HttpMethod.PATCH, callback, sourceSwapShiftsChangeRequest);
    }

    /**
     * Patches this SwapShiftsChangeRequest with a source
     *
     * @param sourceSwapShiftsChangeRequest the source object with updates
     * @return the updated SwapShiftsChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SwapShiftsChangeRequest patch(final SwapShiftsChangeRequest sourceSwapShiftsChangeRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final SwapShiftsChangeRequest newSwapShiftsChangeRequest, final ICallback<? super SwapShiftsChangeRequest> callback) {
        send(HttpMethod.POST, callback, newSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the new object to create
     * @return the created SwapShiftsChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SwapShiftsChangeRequest post(final SwapShiftsChangeRequest newSwapShiftsChangeRequest) throws ClientException {
        return send(HttpMethod.POST, newSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final SwapShiftsChangeRequest newSwapShiftsChangeRequest, final ICallback<? super SwapShiftsChangeRequest> callback) {
        send(HttpMethod.PUT, callback, newSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the object to create/update
     * @return the created SwapShiftsChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SwapShiftsChangeRequest put(final SwapShiftsChangeRequest newSwapShiftsChangeRequest) throws ClientException {
        return send(HttpMethod.PUT, newSwapShiftsChangeRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ISwapShiftsChangeRequestRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (SwapShiftsChangeRequestRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ISwapShiftsChangeRequestRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (SwapShiftsChangeRequestRequest)this;
     }

}

