/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.UserScopeTeamsAppInstallation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserScopeTeamsAppInstallationCollectionPage;
import com.microsoft.graph.requests.extensions.IUserScopeTeamsAppInstallationCollectionRequest;
import com.microsoft.graph.requests.extensions.UserScopeTeamsAppInstallationCollectionPage;
import com.microsoft.graph.requests.extensions.UserScopeTeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UserScopeTeamsAppInstallationCollectionResponse;
import com.microsoft.graph.requests.extensions.UserScopeTeamsAppInstallationRequestBuilder;
import java.util.List;

public class UserScopeTeamsAppInstallationCollectionRequest
extends BaseCollectionRequest<UserScopeTeamsAppInstallationCollectionResponse, IUserScopeTeamsAppInstallationCollectionPage>
implements IUserScopeTeamsAppInstallationCollectionRequest {
    public UserScopeTeamsAppInstallationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserScopeTeamsAppInstallationCollectionResponse.class, IUserScopeTeamsAppInstallationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IUserScopeTeamsAppInstallationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UserScopeTeamsAppInstallationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionPage get() throws ClientException {
        UserScopeTeamsAppInstallationCollectionResponse response = (UserScopeTeamsAppInstallationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(UserScopeTeamsAppInstallation newUserScopeTeamsAppInstallation, ICallback<? super UserScopeTeamsAppInstallation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UserScopeTeamsAppInstallationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newUserScopeTeamsAppInstallation, callback);
    }

    @Override
    public UserScopeTeamsAppInstallation post(UserScopeTeamsAppInstallation newUserScopeTeamsAppInstallation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserScopeTeamsAppInstallationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newUserScopeTeamsAppInstallation);
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IUserScopeTeamsAppInstallationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IUserScopeTeamsAppInstallationCollectionPage buildFromResponse(UserScopeTeamsAppInstallationCollectionResponse response) {
        UserScopeTeamsAppInstallationCollectionRequestBuilder builder = response.nextLink != null ? new UserScopeTeamsAppInstallationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserScopeTeamsAppInstallationCollectionPage page = new UserScopeTeamsAppInstallationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

