// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.AssignedLicense;
import com.microsoft.graph.models.ResourceSpecificPermissionGrant;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.GroupCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.GroupCollectionWithReferencesPage;
import com.microsoft.graph.requests.GroupCollectionResponse;
import com.microsoft.graph.models.Group;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Collection With References Page.
 */
public class GroupCollectionWithReferencesPage extends BaseCollectionPage<Group, GroupCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for Group
     *
     * @param response the serialized GroupCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public GroupCollectionWithReferencesPage(@Nonnull final GroupCollectionResponse response, @Nullable final GroupCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for Group
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public GroupCollectionWithReferencesPage(@Nonnull final java.util.List<Group> pageContents, @Nullable final GroupCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
