/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodsRoot;
import com.microsoft.graph.models.Partners;
import com.microsoft.graph.models.PrintUsageByPrinter;
import com.microsoft.graph.models.PrintUsageByUser;
import com.microsoft.graph.models.SecurityReportsRoot;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ReportRoot
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ReportRoot() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ReportRoot createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ReportRoot();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public AuthenticationMethodsRoot getAuthenticationMethods() {
        return (AuthenticationMethodsRoot)this.backingStore.get("authenticationMethods");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<PrintUsageByPrinter> getDailyPrintUsageByPrinter() {
        return (List)this.backingStore.get("dailyPrintUsageByPrinter");
    }

    @Nullable
    public List<PrintUsageByUser> getDailyPrintUsageByUser() {
        return (List)this.backingStore.get("dailyPrintUsageByUser");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("authenticationMethods", n -> this.setAuthenticationMethods((AuthenticationMethodsRoot)n.getObjectValue(AuthenticationMethodsRoot::createFromDiscriminatorValue)));
        deserializerMap.put("dailyPrintUsageByPrinter", n -> this.setDailyPrintUsageByPrinter(n.getCollectionOfObjectValues(PrintUsageByPrinter::createFromDiscriminatorValue)));
        deserializerMap.put("dailyPrintUsageByUser", n -> this.setDailyPrintUsageByUser(n.getCollectionOfObjectValues(PrintUsageByUser::createFromDiscriminatorValue)));
        deserializerMap.put("monthlyPrintUsageByPrinter", n -> this.setMonthlyPrintUsageByPrinter(n.getCollectionOfObjectValues(PrintUsageByPrinter::createFromDiscriminatorValue)));
        deserializerMap.put("monthlyPrintUsageByUser", n -> this.setMonthlyPrintUsageByUser(n.getCollectionOfObjectValues(PrintUsageByUser::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("partners", n -> this.setPartners((Partners)n.getObjectValue(Partners::createFromDiscriminatorValue)));
        deserializerMap.put("security", n -> this.setSecurity((SecurityReportsRoot)n.getObjectValue(SecurityReportsRoot::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<PrintUsageByPrinter> getMonthlyPrintUsageByPrinter() {
        return (List)this.backingStore.get("monthlyPrintUsageByPrinter");
    }

    @Nullable
    public List<PrintUsageByUser> getMonthlyPrintUsageByUser() {
        return (List)this.backingStore.get("monthlyPrintUsageByUser");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Partners getPartners() {
        return (Partners)this.backingStore.get("partners");
    }

    @Nullable
    public SecurityReportsRoot getSecurity() {
        return (SecurityReportsRoot)this.backingStore.get("security");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("authenticationMethods", (Parsable)this.getAuthenticationMethods(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("dailyPrintUsageByPrinter", this.getDailyPrintUsageByPrinter());
        writer.writeCollectionOfObjectValues("dailyPrintUsageByUser", this.getDailyPrintUsageByUser());
        writer.writeCollectionOfObjectValues("monthlyPrintUsageByPrinter", this.getMonthlyPrintUsageByPrinter());
        writer.writeCollectionOfObjectValues("monthlyPrintUsageByUser", this.getMonthlyPrintUsageByUser());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("partners", (Parsable)this.getPartners(), new Parsable[0]);
        writer.writeObjectValue("security", (Parsable)this.getSecurity(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAuthenticationMethods(@Nullable AuthenticationMethodsRoot value) {
        this.backingStore.set("authenticationMethods", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDailyPrintUsageByPrinter(@Nullable List<PrintUsageByPrinter> value) {
        this.backingStore.set("dailyPrintUsageByPrinter", value);
    }

    public void setDailyPrintUsageByUser(@Nullable List<PrintUsageByUser> value) {
        this.backingStore.set("dailyPrintUsageByUser", value);
    }

    public void setMonthlyPrintUsageByPrinter(@Nullable List<PrintUsageByPrinter> value) {
        this.backingStore.set("monthlyPrintUsageByPrinter", value);
    }

    public void setMonthlyPrintUsageByUser(@Nullable List<PrintUsageByUser> value) {
        this.backingStore.set("monthlyPrintUsageByUser", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPartners(@Nullable Partners value) {
        this.backingStore.set("partners", (Object)value);
    }

    public void setSecurity(@Nullable SecurityReportsRoot value) {
        this.backingStore.set("security", (Object)value);
    }
}

