/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SubjectRightsRequestDetail
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SubjectRightsRequestDetail() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SubjectRightsRequestDetail createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SubjectRightsRequestDetail();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Long getExcludedItemCount() {
        return (Long)this.backingStore.get("excludedItemCount");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("excludedItemCount", n -> this.setExcludedItemCount(n.getLongValue()));
        deserializerMap.put("insightCounts", n -> this.setInsightCounts(n.getCollectionOfObjectValues(KeyValuePair::createFromDiscriminatorValue)));
        deserializerMap.put("itemCount", n -> this.setItemCount(n.getLongValue()));
        deserializerMap.put("itemNeedReview", n -> this.setItemNeedReview(n.getLongValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("productItemCounts", n -> this.setProductItemCounts(n.getCollectionOfObjectValues(KeyValuePair::createFromDiscriminatorValue)));
        deserializerMap.put("signedOffItemCount", n -> this.setSignedOffItemCount(n.getLongValue()));
        deserializerMap.put("totalItemSize", n -> this.setTotalItemSize(n.getLongValue()));
        return deserializerMap;
    }

    @Nullable
    public List<KeyValuePair> getInsightCounts() {
        return (List)this.backingStore.get("insightCounts");
    }

    @Nullable
    public Long getItemCount() {
        return (Long)this.backingStore.get("itemCount");
    }

    @Nullable
    public Long getItemNeedReview() {
        return (Long)this.backingStore.get("itemNeedReview");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<KeyValuePair> getProductItemCounts() {
        return (List)this.backingStore.get("productItemCounts");
    }

    @Nullable
    public Long getSignedOffItemCount() {
        return (Long)this.backingStore.get("signedOffItemCount");
    }

    @Nullable
    public Long getTotalItemSize() {
        return (Long)this.backingStore.get("totalItemSize");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeLongValue("excludedItemCount", this.getExcludedItemCount());
        writer.writeCollectionOfObjectValues("insightCounts", this.getInsightCounts());
        writer.writeLongValue("itemCount", this.getItemCount());
        writer.writeLongValue("itemNeedReview", this.getItemNeedReview());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("productItemCounts", this.getProductItemCounts());
        writer.writeLongValue("signedOffItemCount", this.getSignedOffItemCount());
        writer.writeLongValue("totalItemSize", this.getTotalItemSize());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExcludedItemCount(@Nullable Long value) {
        this.backingStore.set("excludedItemCount", (Object)value);
    }

    public void setInsightCounts(@Nullable List<KeyValuePair> value) {
        this.backingStore.set("insightCounts", value);
    }

    public void setItemCount(@Nullable Long value) {
        this.backingStore.set("itemCount", (Object)value);
    }

    public void setItemNeedReview(@Nullable Long value) {
        this.backingStore.set("itemNeedReview", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProductItemCounts(@Nullable List<KeyValuePair> value) {
        this.backingStore.set("productItemCounts", value);
    }

    public void setSignedOffItemCount(@Nullable Long value) {
        this.backingStore.set("signedOffItemCount", (Object)value);
    }

    public void setTotalItemSize(@Nullable Long value) {
        this.backingStore.set("totalItemSize", (Object)value);
    }
}

