// ------------------------------------------------------------------------------
// Copyright (c) 2017 Microsoft Corporation
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sub-license, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// ------------------------------------------------------------------------------

package com.microsoft.graph.http;


import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.ISerializer;

import javax.annotation.Nullable;
import javax.annotation.Nonnull;

/**
 * The handler interface for requests having stateful response from server.
 * The handler will custom the HTTP connection if needed and generate request
 * result based on the server HTTP response.
 *
 * @param <ResultType>       the result to return
 * @param <DeserializedType> the deserialize type for serializer
 */
public interface IStatefulResponseHandler<ResultType, DeserializedType> {
    /**
     * Generate result after receiving response
     *
     * @param request    the HTTP request
     * @param response the HTTP connection
     * @param serializer the serializer for parsing response
     * @param logger     the logger
     * @param <ResponseType> the native http client response type
     * @return           the result generated by this handler
     * @throws Exception an exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    <ResponseType> ResultType generateResult(@Nonnull final IHttpRequest request,
                              @Nonnull final ResponseType response,
                              @Nonnull final ISerializer serializer,
                              @Nonnull final ILogger logger) throws Exception;
}
