/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.authentication;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;

public abstract class BaseAuthenticationProvider
implements IAuthenticationProvider {
    private static final HashSet<String> validGraphHostNames = new HashSet<String>(Arrays.asList("graph.microsoft.com", "graph.microsoft.us", "dod-graph.microsoft.us", "graph.microsoft.de", "microsoftgraph.chinacloudapi.cn"));

    protected boolean shouldAuthenticateRequestWithUrl(@Nonnull URL requestUrl) {
        if (requestUrl == null || !requestUrl.getProtocol().toLowerCase(Locale.ROOT).equals("https")) {
            return false;
        }
        String hostName = requestUrl.getHost().toLowerCase(Locale.ROOT);
        return validGraphHostNames.contains(hostName);
    }
}

