/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.content;

import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.content.BatchStep;
import com.microsoft.graph.http.GraphErrorResponse;
import com.microsoft.graph.http.GraphFatalServiceException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.serializer.ISerializer;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BatchResponseStep<T>
extends BatchStep<T> {
    @Expose
    @SerializedName(value="status")
    public int status;
    @Nullable
    protected ISerializer serializer;

    @Nullable
    public <T2> T2 getDeserializedBody(@Nonnull Class<T2> resultClass) throws GraphServiceException, GraphFatalServiceException {
        Objects.requireNonNull(resultClass, "parameter resultClass cannot be null");
        if (this.serializer == null || this.body == null || !(this.body instanceof JsonElement)) {
            return null;
        }
        GraphErrorResponse error = this.serializer.deserializeObject((JsonElement)this.body, GraphErrorResponse.class);
        if (error == null || error.error == null) {
            return this.serializer.deserializeObject((JsonElement)this.body, resultClass);
        }
        throw GraphServiceException.createFromResponse("", "", new ArrayList<String>(), "", this.headers, "", this.status, error, false);
    }
}

