/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.CustomRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRedirect;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRetry;
import com.microsoft.graph.httpcore.middlewareoption.RedirectOptions;
import com.microsoft.graph.httpcore.middlewareoption.RetryOptions;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;

public abstract class BaseRequest<T>
implements IHttpRequest {
    private static final String REQUEST_STATS_HEADER_NAME = "SdkVersion";
    public static final String REQUEST_STATS_HEADER_VALUE_FORMAT_STRING = "graph-java/v%s";
    private HttpMethod method;
    private final String requestUrl;
    private final IBaseClient<?> client;
    private final List<HeaderOption> headersOptions;
    protected final List<QueryOption> queryOptions;
    protected final List<FunctionOption> functionOptions;
    private final Class<? extends T> responseClass;
    private boolean useCaches;
    private int maxRedirects = 5;
    private IShouldRedirect shouldRedirect = RedirectOptions.DEFAULT_SHOULD_REDIRECT;
    private int maxRetries = 3;
    private long delay = 3L;
    private IShouldRetry shouldRetry = RetryOptions.DEFAULT_SHOULD_RETRY;

    public BaseRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> options, @Nonnull Class<? extends T> responseClass) {
        String sdkVersion;
        this.requestUrl = Objects.requireNonNull(requestUrl, "parameter requestUrl cannot be null");
        this.client = Objects.requireNonNull(client, "parameter client cannot be null");
        this.responseClass = Objects.requireNonNull(responseClass, "parameter responseClass cannot be null");
        this.headersOptions = new ArrayList<HeaderOption>();
        this.queryOptions = new ArrayList<QueryOption>();
        this.functionOptions = new ArrayList<FunctionOption>();
        if (options != null) {
            for (Option option : options) {
                if (option instanceof HeaderOption) {
                    this.headersOptions.add((HeaderOption)option);
                }
                if (option instanceof QueryOption) {
                    this.queryOptions.add((QueryOption)option);
                }
                if (!(option instanceof FunctionOption)) continue;
                this.functionOptions.add((FunctionOption)option);
            }
        }
        String string = sdkVersion = client == null ? null : client.getServiceSDKVersion();
        if (sdkVersion != null) {
            HeaderOption headerOption = new HeaderOption(REQUEST_STATS_HEADER_NAME, String.format(REQUEST_STATS_HEADER_VALUE_FORMAT_STRING, sdkVersion));
            this.headersOptions.add(headerOption);
        }
    }

    @Override
    @Nullable
    public URL getRequestUrl() {
        String requestUrl = this.addFunctionParameters();
        HttpUrl parsedUrl = HttpUrl.parse((String)requestUrl);
        if (parsedUrl == null) {
            throw new ClientException("Invalid URL " + requestUrl, null);
        }
        HttpUrl.Builder uriBuilder = parsedUrl.newBuilder();
        for (QueryOption option : this.queryOptions) {
            uriBuilder.addQueryParameter(option.getName(), option.getValue().toString());
        }
        try {
            return new URL(uriBuilder.build().toString());
        }
        catch (MalformedURLException e) {
            if (!(this instanceof CustomRequest)) {
                throw new ClientException("Invalid URL: " + uriBuilder, e);
            }
            this.getClient().getLogger().logError("Invalid custom URL: " + uriBuilder, e);
            return null;
        }
    }

    @Override
    @Nullable
    public <requestBodyType, responseType, nativeRequestType> nativeRequestType getHttpRequest(@Nullable requestBodyType serializedObject) throws ClientException {
        return (nativeRequestType)this.client.getHttpProvider().getHttpRequest(this, this.responseClass, serializedObject);
    }

    private String addFunctionParameters() {
        StringBuilder requestUrl = new StringBuilder(this.requestUrl);
        if (!this.getFunctionOptions().isEmpty()) {
            requestUrl.append("(");
            for (int i = 0; i < this.functionOptions.size(); ++i) {
                FunctionOption option = this.functionOptions.get(i);
                requestUrl.append(option.getName());
                requestUrl.append("=");
                if (option.getValue() != null) {
                    if (option.getValue() instanceof String) {
                        requestUrl.append("'").append(option.getValue()).append("'");
                    } else {
                        requestUrl.append(option.getValue());
                    }
                } else {
                    requestUrl.append("null");
                }
                if (i + 1 >= this.functionOptions.size()) continue;
                requestUrl.append(",");
            }
            requestUrl.append(")");
        }
        return requestUrl.toString();
    }

    @Override
    @Nullable
    public HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    @Nullable
    @SuppressFBWarnings
    public List<HeaderOption> getHeaders() {
        return this.headersOptions;
    }

    @Override
    public void addHeader(@Nonnull String header, @Nullable String value) {
        Objects.requireNonNull(header, "parameter header cannot be null");
        this.headersOptions.add(new HeaderOption(header, value));
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    @Override
    public boolean getUseCaches() {
        return this.useCaches;
    }

    @Nonnull
    protected <T1> CompletableFuture<T> sendAsync(@Nonnull HttpMethod method, @Nullable T1 serializedObject) {
        this.method = Objects.requireNonNull(method, "parameter method cannot be null");
        return this.client.getHttpProvider().sendAsync(this, this.responseClass, serializedObject);
    }

    @Nullable
    protected <T1> T send(@Nullable HttpMethod method, @Nullable T1 serializedObject) throws ClientException {
        this.method = method;
        return this.client.getHttpProvider().send(this, this.responseClass, serializedObject);
    }

    @Nullable
    @SuppressFBWarnings
    public List<QueryOption> getQueryOptions() {
        return this.queryOptions;
    }

    @Nullable
    @SuppressFBWarnings
    public List<FunctionOption> getFunctionOptions() {
        return this.functionOptions;
    }

    @Override
    @Nullable
    public List<Option> getOptions() {
        LinkedList<Option> list = new LinkedList<Option>();
        list.addAll(this.headersOptions);
        list.addAll(this.queryOptions);
        list.addAll(this.functionOptions);
        return Collections.unmodifiableList(list);
    }

    public void addQueryOption(@Nonnull QueryOption option) {
        Objects.requireNonNull(option, "parameter option cannot be null");
        this.queryOptions.add(option);
    }

    public void addFunctionOption(@Nonnull FunctionOption option) {
        Objects.requireNonNull(option, "parameter option cannot be null");
        this.functionOptions.add(option);
    }

    protected void addExpandOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$expand", value));
    }

    protected void addFilterOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$filter", value));
    }

    protected void addOrderByOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$orderby", value));
    }

    protected void addSelectOption(@Nonnull String value) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        this.addQueryOption(new QueryOption("$select", value));
    }

    protected void addTopOption(int value) {
        this.addQueryOption(new QueryOption("$top", String.valueOf(value)));
    }

    protected void addSkipOption(int value) {
        this.addQueryOption(new QueryOption("$skip", String.valueOf(value)));
    }

    protected void addSkipTokenOption(@Nonnull String skipToken) {
        Objects.requireNonNull(skipToken, "parameter skipToken cannot be null");
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
    }

    protected void addCountOption(boolean value) {
        this.addQueryOption(new QueryOption("$count", String.valueOf(value)));
    }

    public void setHttpMethod(@Nonnull HttpMethod httpMethod) {
        Objects.requireNonNull(httpMethod, "parameter httpMethod cannot be null");
        this.method = httpMethod;
    }

    @Override
    @Nullable
    public IHttpRequest withHttpMethod(@Nonnull HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    @Nonnull
    @SuppressFBWarnings
    public IBaseClient<?> getClient() {
        return this.client;
    }

    @Nullable
    @SuppressFBWarnings
    public Class<? extends T> getResponseType() {
        return this.responseClass;
    }

    @Override
    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    @Override
    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    @Override
    public void setShouldRedirect(@Nonnull IShouldRedirect shouldRedirect) {
        Objects.requireNonNull(shouldRedirect, "parameter shouldRedirect cannot be null");
        this.shouldRedirect = shouldRedirect;
    }

    @Override
    @Nonnull
    public IShouldRedirect getShouldRedirect() {
        return this.shouldRedirect;
    }

    @Override
    public void setShouldRetry(@Nonnull IShouldRetry shouldretry) {
        Objects.requireNonNull(shouldretry, "parameter shouldretry cannot be null");
        this.shouldRetry = shouldretry;
    }

    @Override
    @Nonnull
    public IShouldRetry getShouldRetry() {
        return this.shouldRetry;
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }
}

