/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.authentication;

import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.authentication.AccessTokenProvider;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;

public class BaseBearerTokenAuthenticationProvider
implements AuthenticationProvider {
    private final AccessTokenProvider accessTokenProvider;
    private static final String authorizationHeaderKey = "Authorization";
    private static final String ClaimsKey = "claims";

    public BaseBearerTokenAuthenticationProvider(@Nonnull AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = Objects.requireNonNull(accessTokenProvider);
    }

    @Override
    public void authenticateRequest(@Nonnull RequestInformation request, @Nullable Map<String, Object> additionalAuthenticationContext) {
        Objects.requireNonNull(request);
        if (request.headers.containsKey(authorizationHeaderKey) && additionalAuthenticationContext != null && additionalAuthenticationContext.containsKey(ClaimsKey)) {
            request.headers.remove(authorizationHeaderKey);
        }
        if (!request.headers.containsKey(authorizationHeaderKey)) {
            URI targetUri;
            try {
                targetUri = request.getUri();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Malformed URI.", e);
            }
            String accessToken = this.accessTokenProvider.getAuthorizationToken(targetUri, additionalAuthenticationContext);
            if (!Compatibility.isBlank(accessToken)) {
                request.headers.add(authorizationHeaderKey, "Bearer " + accessToken);
            }
        }
    }

    @Nonnull
    public AccessTokenProvider getAccessTokenProvider() {
        return this.accessTokenProvider;
    }
}

