/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.middleware.ObservabilityHelper;
import com.microsoft.kiota.http.middleware.options.UrlReplaceHandlerOption;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class UrlReplaceHandler
implements Interceptor {
    private UrlReplaceHandlerOption mUrlReplaceHandlerOption;

    public UrlReplaceHandler() {
        this(new UrlReplaceHandlerOption());
    }

    public UrlReplaceHandler(@Nonnull UrlReplaceHandlerOption urlReplaceHandlerOption) {
        Objects.requireNonNull(urlReplaceHandlerOption);
        this.mUrlReplaceHandlerOption = new UrlReplaceHandlerOption(urlReplaceHandlerOption.getReplacementPairs(), urlReplaceHandlerOption.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Objects.requireNonNull(chain, "parameter chain cannot be null");
        Request request = Objects.requireNonNull(chain.request(), "request cannot be null");
        UrlReplaceHandlerOption replaceOption = (UrlReplaceHandlerOption)request.tag(UrlReplaceHandlerOption.class);
        UrlReplaceHandlerOption urlReplaceHandlerOption = replaceOption = replaceOption == null ? this.mUrlReplaceHandlerOption : replaceOption;
        if (!replaceOption.isEnabled() || replaceOption.getReplacementPairs().isEmpty()) {
            return chain.proceed(request);
        }
        Span span = ObservabilityHelper.getSpanForRequest(request, "UrlReplaceHandler_Intercept");
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.urlreplace.enable", true);
        }
        try {
            request = UrlReplaceHandler.replaceRequestUrl(request, replaceOption.getReplacementPairs());
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
        return chain.proceed(request);
    }

    @Nonnull
    public UrlReplaceHandlerOption getUrlReplaceHandlerOption() {
        return new UrlReplaceHandlerOption(this.mUrlReplaceHandlerOption.getReplacementPairs(), this.mUrlReplaceHandlerOption.isEnabled());
    }

    public void setUrlReplaceHandlerOption(@Nonnull UrlReplaceHandlerOption urlReplaceHandlerOption) {
        this.mUrlReplaceHandlerOption = new UrlReplaceHandlerOption(urlReplaceHandlerOption.getReplacementPairs(), urlReplaceHandlerOption.isEnabled());
    }

    @Nonnull
    public static Request replaceRequestUrl(@Nonnull Request request, @Nonnull Map<String, String> replacementPairs) {
        Request.Builder builder = request.newBuilder();
        String replacedUrl = request.url().toString();
        for (Map.Entry<String, String> entry : replacementPairs.entrySet()) {
            replacedUrl = replacedUrl.replace(entry.getKey(), entry.getValue());
        }
        builder.url(replacedUrl);
        return builder.build();
    }
}

