/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Stream;
import com.microsoft.playwright.impl.Utils;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;

class ArtifactImpl
extends ChannelOwner {
    boolean isRemote;

    public ArtifactImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    public InputStream createReadStream() {
        JsonObject result = this.sendMessage("stream").getAsJsonObject();
        if (!result.has("stream")) {
            return null;
        }
        Stream stream = (Stream)this.connection.getExistingObject(result.getAsJsonObject("stream").get("guid").getAsString());
        return stream.stream();
    }

    public void delete() {
        this.sendMessage("delete");
    }

    public String failure() {
        JsonObject result = this.sendMessage("failure").getAsJsonObject();
        if (result.has("error")) {
            return result.get("error").getAsString();
        }
        return null;
    }

    public Path pathAfterFinished() {
        if (this.isRemote) {
            throw new PlaywrightException("Path is not available when using browserType.connect(). Use download.saveAs() to save a local copy.");
        }
        JsonObject json = this.sendMessage("pathAfterFinished").getAsJsonObject();
        return FileSystems.getDefault().getPath(json.get("value").getAsString(), new String[0]);
    }

    public void saveAs(Path path) {
        if (this.isRemote) {
            JsonObject jsonObject = this.sendMessage("saveAsStream").getAsJsonObject();
            Stream stream = (Stream)this.connection.getExistingObject(jsonObject.getAsJsonObject("stream").get("guid").getAsString());
            Utils.writeToFile(stream.stream(), path);
            return;
        }
        JsonObject params = new JsonObject();
        params.addProperty("path", path.toString());
        this.sendMessage("saveAs", params);
    }
}

