/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.impl.BindingCall;
import com.microsoft.playwright.impl.BrowserImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.Router;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.TimeoutSettings;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.WaitableEvent;
import com.microsoft.playwright.impl.WaitableRace;
import com.microsoft.playwright.options.BindingCallback;
import com.microsoft.playwright.options.Cookie;
import com.microsoft.playwright.options.FunctionCallback;
import com.microsoft.playwright.options.Geolocation;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

class BrowserContextImpl
extends ChannelOwner
implements BrowserContext {
    private final BrowserImpl browser;
    final List<PageImpl> pages = new ArrayList<PageImpl>();
    final Router routes = new Router();
    private boolean isClosedOrClosing;
    final Map<String, BindingCallback> bindings = new HashMap<String, BindingCallback>();
    PageImpl ownerPage;
    private final ListenerCollection<EventType> listeners = new ListenerCollection();
    final TimeoutSettings timeoutSettings = new TimeoutSettings();
    Path videosDir;

    BrowserContextImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.browser = parent instanceof BrowserImpl ? (BrowserImpl)parent : null;
    }

    @Override
    public void onClose(Consumer<BrowserContext> handler) {
        this.listeners.add(EventType.CLOSE, handler);
    }

    @Override
    public void offClose(Consumer<BrowserContext> handler) {
        this.listeners.remove(EventType.CLOSE, handler);
    }

    @Override
    public void onPage(Consumer<Page> handler) {
        this.listeners.add(EventType.PAGE, handler);
    }

    @Override
    public void offPage(Consumer<Page> handler) {
        this.listeners.remove(EventType.PAGE, handler);
    }

    private <T> T waitForEventWithTimeout(EventType eventType, Runnable code, Double timeout) {
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitableEvent(this.listeners, eventType));
        waitables.add(new WaitableContextClose());
        waitables.add(this.timeoutSettings.createWaitable(timeout));
        return this.runUntil(code, new WaitableRace(waitables));
    }

    @Override
    public Page waitForPage(BrowserContext.WaitForPageOptions options, Runnable code) {
        return this.withWaitLogging("BrowserContext.close", () -> this.waitForPageImpl(options, code));
    }

    private Page waitForPageImpl(BrowserContext.WaitForPageOptions options, Runnable code) {
        if (options == null) {
            options = new BrowserContext.WaitForPageOptions();
        }
        return (Page)this.waitForEventWithTimeout(EventType.PAGE, code, options.timeout);
    }

    @Override
    public void close() {
        this.withLogging("BrowserContext.close", () -> this.closeImpl());
    }

    @Override
    public List<Cookie> cookies(String url) {
        return this.cookies(url == null ? new ArrayList<String>() : Arrays.asList(url));
    }

    private void closeImpl() {
        block3: {
            if (this.isClosedOrClosing) {
                return;
            }
            this.isClosedOrClosing = true;
            try {
                this.sendMessage("close");
            }
            catch (PlaywrightException e) {
                if (Utils.isSafeCloseError(e)) break block3;
                throw e;
            }
        }
    }

    @Override
    public void addCookies(List<Cookie> cookies) {
        this.withLogging("BrowserContext.addCookies", () -> {
            JsonObject params = new JsonObject();
            params.add("cookies", Serialization.gson().toJsonTree((Object)cookies));
            this.sendMessage("addCookies", params);
        });
    }

    @Override
    public void addInitScript(String script) {
        this.withLogging("BrowserContext.addInitScript", () -> this.addInitScriptImpl(script));
    }

    @Override
    public void addInitScript(Path path) {
        this.withLogging("BrowserContext.addInitScript", () -> {
            try {
                byte[] bytes = Files.readAllBytes(path);
                this.addInitScriptImpl(new String(bytes, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read script from file", e);
            }
        });
    }

    private void addInitScriptImpl(String script) {
        JsonObject params = new JsonObject();
        params.addProperty("source", script);
        this.sendMessage("addInitScript", params);
    }

    @Override
    public BrowserImpl browser() {
        return this.browser;
    }

    @Override
    public void clearCookies() {
        this.withLogging("BrowserContext.clearCookies", () -> this.sendMessage("clearCookies"));
    }

    @Override
    public void clearPermissions() {
        this.withLogging("BrowserContext.clearPermissions", () -> this.sendMessage("clearPermissions"));
    }

    @Override
    public List<Cookie> cookies(List<String> urls) {
        return this.withLogging("BrowserContext.cookies", () -> this.cookiesImpl(urls));
    }

    private List<Cookie> cookiesImpl(List<String> urls) {
        JsonObject params = new JsonObject();
        if (urls == null) {
            urls = new ArrayList<String>();
        }
        params.add("urls", Serialization.gson().toJsonTree(urls));
        JsonObject json = this.sendMessage("cookies", params).getAsJsonObject();
        Cookie[] cookies = (Cookie[])Serialization.gson().fromJson((JsonElement)json.getAsJsonArray("cookies"), Cookie[].class);
        return Arrays.asList(cookies);
    }

    @Override
    public void exposeBinding(String name, BindingCallback playwrightBinding, BrowserContext.ExposeBindingOptions options) {
        this.withLogging("BrowserContext.exposeBinding", () -> this.exposeBindingImpl(name, playwrightBinding, options));
    }

    private void exposeBindingImpl(String name, BindingCallback playwrightBinding, BrowserContext.ExposeBindingOptions options) {
        if (this.bindings.containsKey(name)) {
            throw new PlaywrightException("Function \"" + name + "\" has been already registered");
        }
        for (PageImpl page : this.pages) {
            if (!page.bindings.containsKey(name)) continue;
            throw new PlaywrightException("Function \"" + name + "\" has been already registered in one of the pages");
        }
        this.bindings.put(name, playwrightBinding);
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        if (options != null && options.handle != null && options.handle.booleanValue()) {
            params.addProperty("needsHandle", Boolean.valueOf(true));
        }
        this.sendMessage("exposeBinding", params);
    }

    @Override
    public void exposeFunction(String name, FunctionCallback playwrightFunction) {
        this.withLogging("BrowserContext.exposeFunction", () -> this.exposeBindingImpl(name, (source, args) -> playwrightFunction.call(args), null));
    }

    @Override
    public void grantPermissions(List<String> permissions, BrowserContext.GrantPermissionsOptions options) {
        this.withLogging("BrowserContext.grantPermissions", () -> this.grantPermissionsImpl(permissions, options));
    }

    private void grantPermissionsImpl(List<String> permissions, BrowserContext.GrantPermissionsOptions options) {
        if (options == null) {
            options = new BrowserContext.GrantPermissionsOptions();
        }
        if (permissions == null) {
            permissions = new ArrayList<String>();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.add("permissions", Serialization.gson().toJsonTree(permissions));
        this.sendMessage("grantPermissions", params);
    }

    @Override
    public PageImpl newPage() {
        return this.withLogging("BrowserContext.newPage", () -> this.newPageImpl());
    }

    private PageImpl newPageImpl() {
        if (this.ownerPage != null) {
            throw new PlaywrightException("Please use browser.newContext()");
        }
        JsonObject json = this.sendMessage("newPage").getAsJsonObject();
        return (PageImpl)this.connection.getExistingObject(json.getAsJsonObject("page").get("guid").getAsString());
    }

    @Override
    public List<Page> pages() {
        return new ArrayList<Page>(this.pages);
    }

    @Override
    public void route(String url, Consumer<Route> handler) {
        this.route(new UrlMatcher(url), handler);
    }

    @Override
    public void route(Pattern url, Consumer<Route> handler) {
        this.route(new UrlMatcher(url), handler);
    }

    @Override
    public void route(Predicate<String> url, Consumer<Route> handler) {
        this.route(new UrlMatcher(url), handler);
    }

    private void route(UrlMatcher matcher, Consumer<Route> handler) {
        this.withLogging("BrowserContext.route", () -> {
            this.routes.add(matcher, handler);
            if (this.routes.size() == 1) {
                JsonObject params = new JsonObject();
                params.addProperty("enabled", Boolean.valueOf(true));
                this.sendMessage("setNetworkInterceptionEnabled", params);
            }
        });
    }

    @Override
    public void setDefaultNavigationTimeout(double timeout) {
        this.withLogging("BrowserContext.setDefaultNavigationTimeout", () -> {
            this.timeoutSettings.setDefaultNavigationTimeout(timeout);
            JsonObject params = new JsonObject();
            params.addProperty("timeout", (Number)timeout);
            this.sendMessage("setDefaultNavigationTimeoutNoReply", params);
        });
    }

    @Override
    public void setDefaultTimeout(double timeout) {
        this.withLogging("BrowserContext.setDefaultTimeout", () -> {
            this.timeoutSettings.setDefaultTimeout(timeout);
            JsonObject params = new JsonObject();
            params.addProperty("timeout", (Number)timeout);
            this.sendMessage("setDefaultTimeoutNoReply", params);
        });
    }

    @Override
    public void setExtraHTTPHeaders(Map<String, String> headers) {
        this.withLogging("BrowserContext.setExtraHTTPHeaders", () -> {
            JsonObject params = new JsonObject();
            JsonArray jsonHeaders = new JsonArray();
            for (Map.Entry e : headers.entrySet()) {
                JsonObject header = new JsonObject();
                header.addProperty("name", (String)e.getKey());
                header.addProperty("value", (String)e.getValue());
                jsonHeaders.add((JsonElement)header);
            }
            params.add("headers", (JsonElement)jsonHeaders);
            this.sendMessage("setExtraHTTPHeaders", params);
        });
    }

    @Override
    public void setGeolocation(Geolocation geolocation) {
        this.withLogging("BrowserContext.setGeolocation", () -> {
            JsonObject params = new JsonObject();
            if (geolocation != null) {
                params.add("geolocation", Serialization.gson().toJsonTree((Object)geolocation));
            }
            this.sendMessage("setGeolocation", params);
        });
    }

    @Override
    public void setOffline(boolean offline) {
        this.withLogging("BrowserContext.setOffline", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("offline", Boolean.valueOf(offline));
            this.sendMessage("setOffline", params);
        });
    }

    @Override
    public String storageState(BrowserContext.StorageStateOptions options) {
        return this.withLogging("BrowserContext.storageState", () -> {
            JsonElement json = this.sendMessage("storageState");
            String storageState = json.toString();
            if (options != null && options.path != null) {
                Utils.writeToFile(storageState.getBytes(StandardCharsets.UTF_8), options.path);
            }
            return storageState;
        });
    }

    @Override
    public void unroute(String url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(url), handler);
    }

    @Override
    public void unroute(Pattern url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(url), handler);
    }

    @Override
    public void unroute(Predicate<String> url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(url), handler);
    }

    private void unroute(UrlMatcher matcher, Consumer<Route> handler) {
        this.withLogging("BrowserContext.unroute", () -> {
            this.routes.remove(matcher, handler);
            if (this.routes.size() == 0) {
                JsonObject params = new JsonObject();
                params.addProperty("enabled", Boolean.valueOf(false));
                this.sendMessage("setNetworkInterceptionEnabled", params);
            }
        });
    }

    void pause() {
        this.sendMessage("pause");
    }

    @Override
    protected void handleEvent(String event, JsonObject params) {
        if ("route".equals(event)) {
            Route route = (Route)this.connection.getExistingObject(params.getAsJsonObject("route").get("guid").getAsString());
            boolean handled = this.routes.handle(route);
            if (!handled) {
                route.resume();
            }
        } else if ("page".equals(event)) {
            PageImpl page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
            this.pages.add(page);
            this.listeners.notify(EventType.PAGE, page);
            if (page.opener() != null && !page.opener().isClosed()) {
                page.opener().notifyPopup(page);
            }
        } else if ("bindingCall".equals(event)) {
            BindingCall bindingCall = (BindingCall)this.connection.getExistingObject(params.getAsJsonObject("binding").get("guid").getAsString());
            BindingCallback binding = this.bindings.get(bindingCall.name());
            if (binding != null) {
                bindingCall.call(binding);
            }
        } else if ("close".equals(event)) {
            this.didClose();
        }
    }

    void didClose() {
        this.isClosedOrClosing = true;
        if (this.browser != null) {
            this.browser.contexts.remove(this);
        }
        this.listeners.notify(EventType.CLOSE, this);
    }

    private class WaitableContextClose<R>
    extends WaitableEvent<EventType, R> {
        WaitableContextClose() {
            super(BrowserContextImpl.this.listeners, EventType.CLOSE);
        }

        @Override
        public R get() {
            throw new PlaywrightException("Context closed");
        }
    }

    static enum EventType {
        CLOSE,
        PAGE;

    }
}

