/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

class BrowserImpl
extends ChannelOwner
implements Browser {
    final Set<BrowserContextImpl> contexts = new HashSet<BrowserContextImpl>();
    private final ListenerCollection<EventType> listeners = new ListenerCollection();
    boolean isRemote;
    boolean isConnectedOverWebSocket;
    private boolean isConnected = true;

    BrowserImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public void onDisconnected(Consumer<Browser> handler) {
        this.listeners.add(EventType.DISCONNECTED, handler);
    }

    @Override
    public void offDisconnected(Consumer<Browser> handler) {
        this.listeners.remove(EventType.DISCONNECTED, handler);
    }

    @Override
    public void close() {
        this.withLogging("Browser.close", () -> this.closeImpl());
    }

    private void closeImpl() {
        block5: {
            if (this.isConnectedOverWebSocket) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    throw new PlaywrightException("Failed to close browser connection", e);
                }
                this.notifyRemoteClosed();
                return;
            }
            try {
                this.sendMessage("close");
            }
            catch (PlaywrightException e) {
                if (Utils.isSafeCloseError(e)) break block5;
                throw e;
            }
        }
    }

    void notifyRemoteClosed() {
        for (BrowserContextImpl context : new ArrayList<BrowserContextImpl>(this.contexts)) {
            for (PageImpl page : new ArrayList<PageImpl>(context.pages)) {
                page.didClose();
            }
            context.didClose();
        }
        this.didClose();
    }

    @Override
    public List<BrowserContext> contexts() {
        return new ArrayList<BrowserContext>(this.contexts);
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public BrowserContextImpl newContext(Browser.NewContextOptions options) {
        return this.withLogging("Browser.newContext", () -> this.newContextImpl(options));
    }

    private BrowserContextImpl newContextImpl(Browser.NewContextOptions options) {
        if (options == null) {
            options = new Browser.NewContextOptions();
        }
        if (options.storageStatePath != null) {
            try {
                byte[] bytes = Files.readAllBytes(options.storageStatePath);
                options.storageState = new String(bytes, StandardCharsets.UTF_8);
                options.storageStatePath = null;
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read storage state from file", e);
            }
        }
        JsonObject storageState = null;
        if (options.storageState != null) {
            storageState = (JsonObject)new Gson().fromJson(options.storageState, JsonObject.class);
            options.storageState = null;
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (storageState != null) {
            params.add("storageState", (JsonElement)storageState);
        }
        if (options.recordHarPath != null) {
            JsonObject recordHar = new JsonObject();
            recordHar.addProperty("path", options.recordHarPath.toString());
            if (options.recordHarOmitContent != null) {
                recordHar.addProperty("omitContent", Boolean.valueOf(true));
            }
            params.remove("recordHarPath");
            params.remove("recordHarOmitContent");
            params.add("recordHar", (JsonElement)recordHar);
        } else if (options.recordHarOmitContent != null) {
            throw new PlaywrightException("recordHarOmitContent is set but recordHarPath is null");
        }
        if (options.recordVideoDir != null) {
            JsonObject recordVideo = new JsonObject();
            recordVideo.addProperty("dir", options.recordVideoDir.toString());
            if (options.recordVideoSize != null) {
                recordVideo.add("size", Serialization.gson().toJsonTree((Object)options.recordVideoSize));
            }
            params.remove("recordVideoDir");
            params.remove("recordVideoSize");
            params.add("recordVideo", (JsonElement)recordVideo);
        } else if (options.recordVideoSize != null) {
            throw new PlaywrightException("recordVideoSize is set but recordVideoDir is null");
        }
        if (options.viewportSize != null) {
            if (options.viewportSize.isPresent()) {
                JsonElement size = params.get("viewportSize");
                params.remove("viewportSize");
                params.add("viewport", size);
            } else {
                params.remove("viewportSize");
                params.addProperty("noDefaultViewport", Boolean.valueOf(true));
            }
        }
        params.addProperty("sdkLanguage", "java");
        JsonElement result = this.sendMessage("newContext", params);
        BrowserContextImpl context = (BrowserContextImpl)this.connection.getExistingObject(result.getAsJsonObject().getAsJsonObject("context").get("guid").getAsString());
        if (options.recordVideoDir != null) {
            context.videosDir = options.recordVideoDir;
        }
        this.contexts.add(context);
        return context;
    }

    @Override
    public Page newPage(Browser.NewPageOptions options) {
        return this.withLogging("Browser.newPage", () -> this.newPageImpl(options));
    }

    @Override
    public void startTracing(Page page, Browser.StartTracingOptions options) {
        this.withLogging("Browser.startTracing", () -> this.startTracingImpl(page, options));
    }

    private void startTracingImpl(Page page, Browser.StartTracingOptions options) {
        if (options == null) {
            options = new Browser.StartTracingOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (page != null) {
            JsonObject jsonPage = new JsonObject();
            jsonPage.addProperty("guid", ((PageImpl)page).guid);
            params.add("page", (JsonElement)jsonPage);
        }
        this.sendMessage("startTracing", params);
    }

    @Override
    public byte[] stopTracing() {
        return this.withLogging("Browser.stopTracing", () -> this.stopTracingImpl());
    }

    private byte[] stopTracingImpl() {
        JsonObject json = this.sendMessage("stopTracing").getAsJsonObject();
        return Base64.getDecoder().decode(json.get("binary").getAsString());
    }

    private Page newPageImpl(Browser.NewPageOptions options) {
        BrowserContextImpl context = this.newContext(Utils.convertViaJson(options, Browser.NewContextOptions.class));
        PageImpl page = context.newPage();
        page.ownedContext = context;
        context.ownerPage = page;
        return page;
    }

    private String name() {
        return this.initializer.get("name").getAsString();
    }

    boolean isChromium() {
        return "chromium".equals(this.name());
    }

    @Override
    public String version() {
        return this.initializer.get("version").getAsString();
    }

    @Override
    void handleEvent(String event, JsonObject parameters) {
        if ("close".equals(event)) {
            this.didClose();
        }
    }

    private void didClose() {
        this.isConnected = false;
        this.listeners.notify(EventType.DISCONNECTED, this);
    }

    static enum EventType {
        DISCONNECTED;

    }
}

