/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.BrowserImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Connection;
import com.microsoft.playwright.impl.PlaywrightImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.WebSocketTransport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

class BrowserTypeImpl
extends ChannelOwner
implements BrowserType {
    BrowserTypeImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public BrowserImpl launch(BrowserType.LaunchOptions options) {
        return this.withLogging("BrowserType.launch", () -> this.launchImpl(options));
    }

    private BrowserImpl launchImpl(BrowserType.LaunchOptions options) {
        if (options == null) {
            options = new BrowserType.LaunchOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        JsonElement result = this.sendMessage("launch", params);
        return (BrowserImpl)this.connection.getExistingObject(result.getAsJsonObject().getAsJsonObject("browser").get("guid").getAsString());
    }

    @Override
    public Browser connect(String wsEndpoint, BrowserType.ConnectOptions options) {
        return this.withLogging("BrowserType.connect", () -> this.connectImpl(wsEndpoint, options));
    }

    private Browser connectImpl(String wsEndpoint, BrowserType.ConnectOptions options) {
        try {
            Duration timeout = Duration.ofDays(1L);
            Map<String, String> headers = Collections.emptyMap();
            if (options != null) {
                if (options.timeout != null) {
                    timeout = Duration.ofMillis(Math.round(options.timeout));
                }
                if (options.headers != null) {
                    headers = options.headers;
                }
            }
            WebSocketTransport transport = new WebSocketTransport(new URI(wsEndpoint), headers, timeout);
            Connection connection = new Connection(transport);
            PlaywrightImpl playwright = (PlaywrightImpl)connection.waitForObjectWithKnownName("Playwright");
            if (!playwright.initializer.has("preLaunchedBrowser")) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                throw new PlaywrightException("Malformed endpoint. Did you use launchServer method?");
            }
            playwright.initSharedSelectors((PlaywrightImpl)this.connection.getExistingObject("Playwright"));
            BrowserImpl browser = (BrowserImpl)connection.getExistingObject(playwright.initializer.getAsJsonObject("preLaunchedBrowser").get("guid").getAsString());
            browser.isRemote = true;
            browser.isConnectedOverWebSocket = true;
            Consumer<WebSocketTransport> connectionCloseListener = t -> browser.notifyRemoteClosed();
            transport.onClose(connectionCloseListener);
            browser.onDisconnected(b -> {
                playwright.unregisterSelectors();
                transport.offClose(connectionCloseListener);
                try {
                    connection.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            });
            return browser;
        }
        catch (URISyntaxException e) {
            throw new PlaywrightException("Failed to connect", e);
        }
    }

    @Override
    public Browser connectOverCDP(String endpointURL, BrowserType.ConnectOverCDPOptions options) {
        if (!"chromium".equals(this.name())) {
            throw new PlaywrightException("Connecting over CDP is only supported in Chromium.");
        }
        return this.withLogging("BrowserType.connectOverCDP", () -> this.connectOverCDPImpl(endpointURL, options));
    }

    private Browser connectOverCDPImpl(String endpointURL, BrowserType.ConnectOverCDPOptions options) {
        if (options == null) {
            options = new BrowserType.ConnectOverCDPOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("sdkLanguage", "java");
        params.addProperty("endpointURL", endpointURL);
        JsonObject json = this.sendMessage("connectOverCDP", params).getAsJsonObject();
        BrowserImpl browser = (BrowserImpl)this.connection.getExistingObject(json.getAsJsonObject("browser").get("guid").getAsString());
        browser.isRemote = true;
        if (json.has("defaultContext")) {
            String contextId = json.getAsJsonObject("defaultContext").get("guid").getAsString();
            BrowserContextImpl defaultContext = (BrowserContextImpl)this.connection.getExistingObject(contextId);
            browser.contexts.add(defaultContext);
        }
        return browser;
    }

    @Override
    public String executablePath() {
        return this.initializer.get("executablePath").getAsString();
    }

    @Override
    public BrowserContextImpl launchPersistentContext(Path userDataDir, BrowserType.LaunchPersistentContextOptions options) {
        return this.withLogging("BrowserType.launchPersistentContext", () -> this.launchPersistentContextImpl(userDataDir, options));
    }

    private BrowserContextImpl launchPersistentContextImpl(Path userDataDir, BrowserType.LaunchPersistentContextOptions options) {
        if (options == null) {
            options = new BrowserType.LaunchPersistentContextOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("userDataDir", userDataDir.toString());
        if (options.recordHarPath != null) {
            JsonObject recordHar = new JsonObject();
            recordHar.addProperty("path", options.recordHarPath.toString());
            if (options.recordHarOmitContent != null) {
                recordHar.addProperty("omitContent", Boolean.valueOf(true));
            }
            params.remove("recordHarPath");
            params.remove("recordHarOmitContent");
            params.add("recordHar", (JsonElement)recordHar);
        } else if (options.recordHarOmitContent != null) {
            throw new PlaywrightException("recordHarOmitContent is set but recordHarPath is null");
        }
        if (options.recordVideoDir != null) {
            JsonObject recordVideo = new JsonObject();
            recordVideo.addProperty("dir", options.recordVideoDir.toString());
            if (options.recordVideoSize != null) {
                recordVideo.add("size", Serialization.gson().toJsonTree((Object)options.recordVideoSize));
            }
            params.remove("recordVideoDir");
            params.remove("recordVideoSize");
            params.add("recordVideo", (JsonElement)recordVideo);
        } else if (options.recordVideoSize != null) {
            throw new PlaywrightException("recordVideoSize is set but recordVideoDir is null");
        }
        if (options.viewportSize != null) {
            if (options.viewportSize.isPresent()) {
                JsonElement size = params.get("viewportSize");
                params.remove("viewportSize");
                params.add("viewport", size);
            } else {
                params.remove("viewportSize");
                params.addProperty("noDefaultViewport", Boolean.valueOf(true));
            }
        }
        params.addProperty("sdkLanguage", "java");
        JsonObject json = this.sendMessage("launchPersistentContext", params).getAsJsonObject();
        BrowserContextImpl context = (BrowserContextImpl)this.connection.getExistingObject(json.getAsJsonObject("context").get("guid").getAsString());
        if (options.recordVideoDir != null) {
            context.videosDir = options.recordVideoDir;
        }
        return context;
    }

    @Override
    public String name() {
        return this.initializer.get("name").getAsString();
    }
}

