/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.TimeoutError;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.BindingCall;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.BrowserImpl;
import com.microsoft.playwright.impl.BrowserTypeImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ConsoleMessageImpl;
import com.microsoft.playwright.impl.DialogImpl;
import com.microsoft.playwright.impl.DriverException;
import com.microsoft.playwright.impl.ElementHandleImpl;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.JSHandleImpl;
import com.microsoft.playwright.impl.LoggingSupport;
import com.microsoft.playwright.impl.Message;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.PlaywrightImpl;
import com.microsoft.playwright.impl.RequestImpl;
import com.microsoft.playwright.impl.ResponseImpl;
import com.microsoft.playwright.impl.RouteImpl;
import com.microsoft.playwright.impl.SelectorsImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Stream;
import com.microsoft.playwright.impl.Transport;
import com.microsoft.playwright.impl.WaitableResult;
import com.microsoft.playwright.impl.WebSocketImpl;
import com.microsoft.playwright.impl.WorkerImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class Connection {
    private final Transport transport;
    private final Map<String, ChannelOwner> objects = new HashMap<String, ChannelOwner>();
    private final Root root;
    private int lastId = 0;
    private final Path srcDir;
    private final Map<Integer, WaitableResult<JsonElement>> callbacks = new HashMap<Integer, WaitableResult<JsonElement>>();
    private static final boolean isLogging;

    Connection(Transport transport) {
        this.transport = transport;
        this.root = new Root(this);
        String srcRoot = System.getenv("PLAYWRIGHT_JAVA_SRC");
        if (srcRoot == null) {
            this.srcDir = null;
        } else {
            this.srcDir = Paths.get(srcRoot, new String[0]);
            if (!Files.exists(this.srcDir, new LinkOption[0])) {
                throw new PlaywrightException("PLAYWRIGHT_JAVA_SRC environment variable points to non-existing location: '" + srcRoot + "'");
            }
        }
    }

    void close() throws IOException {
        this.transport.close();
    }

    public JsonElement sendMessage(String guid, String method, JsonObject params) {
        return this.root.runUntil(() -> {}, this.sendMessageAsync(guid, method, params));
    }

    public WaitableResult<JsonElement> sendMessageAsync(String guid, String method, JsonObject params) {
        return this.internalSendMessage(guid, method, params);
    }

    private String sourceFile(StackTraceElement frame) {
        String pkg = frame.getClassName();
        int lastDot = pkg.lastIndexOf(46);
        pkg = lastDot == -1 ? "" : frame.getClassName().substring(0, lastDot + 1);
        pkg = pkg.replace('.', File.separatorChar);
        return this.srcDir.resolve(pkg).resolve(frame.getFileName()).toString();
    }

    private JsonArray currentStackTrace() {
        int index;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (index = 0; index < stack.length && !stack[index].getClassName().equals(this.getClass().getName()); ++index) {
        }
        while (index < stack.length && stack[index].getClassName().startsWith("com.microsoft.playwright.") && !stack[index].getClassName().startsWith("com.microsoft.playwright.Test")) {
            ++index;
        }
        JsonArray jsonStack = new JsonArray();
        while (index < stack.length) {
            StackTraceElement frame = stack[index];
            JsonObject jsonFrame = new JsonObject();
            jsonFrame.addProperty("file", this.sourceFile(frame));
            jsonFrame.addProperty("line", (Number)frame.getLineNumber());
            jsonFrame.addProperty("function", frame.getClassName() + "." + frame.getMethodName());
            jsonStack.add((JsonElement)jsonFrame);
            ++index;
        }
        return jsonStack;
    }

    private WaitableResult<JsonElement> internalSendMessage(String guid, String method, JsonObject params) {
        int id = ++this.lastId;
        WaitableResult<JsonElement> result = new WaitableResult<JsonElement>();
        this.callbacks.put(id, result);
        JsonObject message = new JsonObject();
        message.addProperty("id", (Number)id);
        message.addProperty("guid", guid);
        message.addProperty("method", method);
        message.add("params", (JsonElement)params);
        if (this.srcDir != null) {
            JsonObject metadata = new JsonObject();
            metadata.add("stack", (JsonElement)this.currentStackTrace());
            message.add("metadata", (JsonElement)metadata);
        }
        String messageString = Serialization.gson().toJson((JsonElement)message);
        if (isLogging) {
            LoggingSupport.logWithTimestamp("SEND \u25ba " + messageString);
        }
        this.transport.send(messageString);
        return result;
    }

    public ChannelOwner waitForObjectWithKnownName(String guid) {
        while (!this.objects.containsKey(guid)) {
            this.processOneMessage();
        }
        return this.objects.get(guid);
    }

    public <T> T getExistingObject(String guid) {
        ChannelOwner result = this.objects.get(guid);
        if (result == null) {
            throw new PlaywrightException("Object doesn't exist: " + guid);
        }
        return (T)result;
    }

    void registerObject(String guid, ChannelOwner object) {
        this.objects.put(guid, object);
    }

    void unregisterObject(String guid) {
        this.objects.remove(guid);
    }

    void processOneMessage() {
        String messageString = this.transport.poll(Duration.ofMillis(10L));
        if (messageString == null) {
            return;
        }
        if (isLogging) {
            LoggingSupport.logWithTimestamp("\u25c0 RECV " + messageString);
        }
        Gson gson = Serialization.gson();
        Message message = (Message)gson.fromJson(messageString, Message.class);
        this.dispatch(message);
    }

    private void dispatch(Message message) {
        if (message.id != 0) {
            WaitableResult<JsonElement> callback = this.callbacks.get(message.id);
            if (callback == null) {
                throw new PlaywrightException("Cannot find command to respond: " + message.id);
            }
            this.callbacks.remove(message.id);
            if (message.error == null) {
                callback.complete(message.result);
            } else if (message.error.error == null) {
                callback.completeExceptionally(new PlaywrightException(message.error.toString()));
            } else if ("TimeoutError".equals(message.error.error.name)) {
                callback.completeExceptionally(new TimeoutError(message.error.error.toString()));
            } else {
                callback.completeExceptionally(new DriverException(message.error.error));
            }
            return;
        }
        if (message.method == null) {
            return;
        }
        if (message.method.equals("__create__")) {
            this.createRemoteObject(message.guid, message.params);
            return;
        }
        if (message.method.equals("__dispose__")) {
            ChannelOwner object = this.objects.get(message.guid);
            if (object == null) {
                throw new PlaywrightException("Cannot find object to dispose: " + message.guid);
            }
            object.disconnect();
            return;
        }
        ChannelOwner object = this.objects.get(message.guid);
        if (object == null) {
            throw new PlaywrightException("Cannot find object to call " + message.method + ": " + message.guid);
        }
        object.handleEvent(message.method, message.params);
    }

    private ChannelOwner createRemoteObject(String parentGuid, JsonObject params) {
        String type = params.get("type").getAsString();
        String guid = params.get("guid").getAsString();
        ChannelOwner parent = this.objects.get(parentGuid);
        if (parent == null) {
            throw new PlaywrightException("Cannot find parent object " + parentGuid + " to create " + guid);
        }
        JsonObject initializer = params.getAsJsonObject("initializer");
        ChannelOwner result = null;
        switch (type) {
            case "Android": {
                break;
            }
            case "AndroidSocket": {
                break;
            }
            case "AndroidDevice": {
                break;
            }
            case "Artifact": {
                result = new ArtifactImpl(parent, type, guid, initializer);
                break;
            }
            case "BindingCall": {
                result = new BindingCall(parent, type, guid, initializer);
                break;
            }
            case "BrowserType": {
                result = new BrowserTypeImpl(parent, type, guid, initializer);
                break;
            }
            case "Browser": {
                result = new BrowserImpl(parent, type, guid, initializer);
                break;
            }
            case "BrowserContext": {
                result = new BrowserContextImpl(parent, type, guid, initializer);
                break;
            }
            case "ConsoleMessage": {
                result = new ConsoleMessageImpl(parent, type, guid, initializer);
                break;
            }
            case "Dialog": {
                result = new DialogImpl(parent, type, guid, initializer);
                break;
            }
            case "Electron": {
                break;
            }
            case "ElementHandle": {
                result = new ElementHandleImpl(parent, type, guid, initializer);
                break;
            }
            case "Frame": {
                result = new FrameImpl(parent, type, guid, initializer);
                break;
            }
            case "JSHandle": {
                result = new JSHandleImpl(parent, type, guid, initializer);
                break;
            }
            case "Page": {
                result = new PageImpl(parent, type, guid, initializer);
                break;
            }
            case "Playwright": {
                result = new PlaywrightImpl(parent, type, guid, initializer);
                break;
            }
            case "Request": {
                result = new RequestImpl(parent, type, guid, initializer);
                break;
            }
            case "Response": {
                result = new ResponseImpl(parent, type, guid, initializer);
                break;
            }
            case "Route": {
                result = new RouteImpl(parent, type, guid, initializer);
                break;
            }
            case "Stream": {
                result = new Stream(parent, type, guid, initializer);
                break;
            }
            case "Selectors": {
                result = new SelectorsImpl(parent, type, guid, initializer);
                break;
            }
            case "WebSocket": {
                result = new WebSocketImpl(parent, type, guid, initializer);
                break;
            }
            case "Worker": {
                result = new WorkerImpl(parent, type, guid, initializer);
                break;
            }
            default: {
                throw new PlaywrightException("Unknown type " + type);
            }
        }
        return result;
    }

    static {
        String debug = System.getenv("DEBUG");
        isLogging = debug != null && debug.contains("pw:channel");
    }

    class Root
    extends ChannelOwner {
        Root(Connection connection) {
            super(connection, "", "");
        }
    }
}

