/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Download;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.LoggingSupport;
import java.io.InputStream;
import java.nio.file.Path;

class DownloadImpl
extends LoggingSupport
implements Download {
    private final ArtifactImpl artifact;
    private final JsonObject initializer;

    DownloadImpl(ArtifactImpl artifact, JsonObject initializer) {
        this.artifact = artifact;
        this.initializer = initializer;
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    @Override
    public String suggestedFilename() {
        return this.initializer.get("suggestedFilename").getAsString();
    }

    @Override
    public InputStream createReadStream() {
        return this.withLogging("Download.createReadStream", () -> this.artifact.createReadStream());
    }

    @Override
    public void delete() {
        this.withLogging("Download.delete", () -> this.artifact.delete());
    }

    @Override
    public String failure() {
        return this.withLogging("Download.failure", () -> this.artifact.failure());
    }

    @Override
    public Path path() {
        return this.withLogging("Download.path", () -> this.artifact.pathAfterFinished());
    }

    @Override
    public void saveAs(Path path) {
        this.withLogging("Download.saveAs", () -> this.artifact.saveAs(path));
    }
}

