/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Keyboard;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.LoggingSupport;
import com.microsoft.playwright.impl.Serialization;

class KeyboardImpl
extends LoggingSupport
implements Keyboard {
    private final ChannelOwner page;

    KeyboardImpl(ChannelOwner page) {
        this.page = page;
    }

    @Override
    public void down(String key) {
        this.withLogging("Keyboard.down", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("key", key);
            this.page.sendMessage("keyboardDown", params);
        });
    }

    @Override
    public void insertText(String text) {
        this.withLogging("Keyboard.insertText", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("text", text);
            this.page.sendMessage("keyboardInsertText", params);
        });
    }

    @Override
    public void press(String key, Keyboard.PressOptions options) {
        this.withLogging("Keyboard.press", () -> this.pressImpl(key, options));
    }

    private void pressImpl(String key, Keyboard.PressOptions options) {
        if (options == null) {
            options = new Keyboard.PressOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("key", key);
        this.page.sendMessage("keyboardPress", params);
    }

    @Override
    public void type(String text, Keyboard.TypeOptions options) {
        this.withLogging("Keyboard.type", () -> this.typeImpl(text, options));
    }

    private void typeImpl(String text, Keyboard.TypeOptions options) {
        if (options == null) {
            options = new Keyboard.TypeOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("text", text);
        this.page.sendMessage("keyboardType", params);
    }

    @Override
    public void up(String key) {
        this.withLogging("Keyboard.up", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("key", key);
            this.page.sendMessage("keyboardUp", params);
        });
    }
}

