/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Mouse;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;

class MouseImpl
implements Mouse {
    private final ChannelOwner page;

    MouseImpl(ChannelOwner page) {
        this.page = page;
    }

    @Override
    public void click(double x, double y, Mouse.ClickOptions options) {
        this.page.withLogging("Mouse.click", () -> this.clickImpl(x, y, options));
    }

    private void clickImpl(double x, double y, Mouse.ClickOptions options) {
        if (options == null) {
            options = new Mouse.ClickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("x", (Number)x);
        params.addProperty("y", (Number)y);
        this.page.sendMessage("mouseClick", params);
    }

    @Override
    public void dblclick(double x, double y, Mouse.DblclickOptions options) {
        this.page.withLogging("Mouse.dblclick", () -> this.dblclickImpl(x, y, options));
    }

    private void dblclickImpl(double x, double y, Mouse.DblclickOptions options) {
        Mouse.ClickOptions clickOptions = options == null ? new Mouse.ClickOptions() : Utils.convertViaJson(options, Mouse.ClickOptions.class);
        clickOptions.clickCount = 2;
        this.click(x, y, clickOptions);
    }

    @Override
    public void down(Mouse.DownOptions options) {
        this.page.withLogging("Mouse.down", () -> this.downImpl(options));
    }

    private void downImpl(Mouse.DownOptions options) {
        if (options == null) {
            options = new Mouse.DownOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.page.sendMessage("mouseDown", params);
    }

    @Override
    public void move(double x, double y, Mouse.MoveOptions options) {
        this.page.withLogging("Mouse.move", () -> this.moveImpl(x, y, options));
    }

    private void moveImpl(double x, double y, Mouse.MoveOptions options) {
        if (options == null) {
            options = new Mouse.MoveOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("x", (Number)x);
        params.addProperty("y", (Number)y);
        this.page.sendMessage("mouseMove", params);
    }

    @Override
    public void up(Mouse.UpOptions options) {
        this.page.withLogging("Mouse.up", () -> this.upImpl(options));
    }

    private void upImpl(Mouse.UpOptions options) {
        if (options == null) {
            options = new Mouse.UpOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.page.sendMessage("mouseUp", params);
    }
}

