/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Selectors;
import com.microsoft.playwright.impl.BrowserTypeImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Connection;
import com.microsoft.playwright.impl.Driver;
import com.microsoft.playwright.impl.PipeTransport;
import com.microsoft.playwright.impl.SelectorsImpl;
import com.microsoft.playwright.impl.SharedSelectors;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

public class PlaywrightImpl
extends ChannelOwner
implements Playwright {
    private Process driverProcess;
    private final BrowserTypeImpl chromium;
    private final BrowserTypeImpl firefox;
    private final BrowserTypeImpl webkit;
    private final SelectorsImpl selectors;
    private SharedSelectors sharedSelectors;

    public static PlaywrightImpl create() {
        try {
            Path driver = Driver.ensureDriverInstalled();
            ProcessBuilder pb = new ProcessBuilder(driver.toString(), "run-driver");
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            Connection connection = new Connection(new PipeTransport(p.getInputStream(), p.getOutputStream()));
            PlaywrightImpl result = (PlaywrightImpl)connection.waitForObjectWithKnownName("Playwright");
            result.driverProcess = p;
            result.initSharedSelectors(null);
            return result;
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to launch driver", e);
        }
    }

    PlaywrightImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.chromium = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("chromium").get("guid").getAsString());
        this.firefox = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("firefox").get("guid").getAsString());
        this.webkit = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("webkit").get("guid").getAsString());
        this.selectors = (SelectorsImpl)this.connection.getExistingObject(initializer.getAsJsonObject("selectors").get("guid").getAsString());
    }

    void initSharedSelectors(PlaywrightImpl parent) {
        assert (this.sharedSelectors == null);
        this.sharedSelectors = parent == null ? new SharedSelectors() : parent.sharedSelectors;
        this.sharedSelectors.addChannel(this.selectors);
    }

    void unregisterSelectors() {
        this.sharedSelectors.removeChannel(this.selectors);
    }

    @Override
    public BrowserTypeImpl chromium() {
        return this.chromium;
    }

    @Override
    public BrowserTypeImpl firefox() {
        return this.firefox;
    }

    @Override
    public BrowserTypeImpl webkit() {
        return this.webkit;
    }

    @Override
    public Selectors selectors() {
        return this.sharedSelectors;
    }

    @Override
    public void close() {
        try {
            this.connection.close();
            boolean didClose = this.driverProcess.waitFor(30L, TimeUnit.SECONDS);
            if (!didClose) {
                System.err.println("WARNING: Timed out while waiting for driver process to exit");
            }
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to terminate", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlaywrightException("Operation interrupted", e);
        }
    }
}

