/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;

class ReaderThread
extends Thread {
    private final DataInputStream in;
    private final BlockingQueue<String> queue;
    volatile boolean isClosing;
    volatile Exception exception;

    private static int readIntLE(DataInputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    ReaderThread(DataInputStream in, BlockingQueue<String> queue) {
        this.in = in;
        this.queue = queue;
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                this.queue.put(this.readMessage());
            }
            catch (IOException e) {
                if (this.isInterrupted() || this.isClosing) break;
                this.exception = e;
                break;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private String readMessage() throws IOException {
        int len = ReaderThread.readIntLE(this.in);
        byte[] raw = new byte[len];
        this.in.readFully(raw, 0, len);
        return new String(raw, StandardCharsets.UTF_8);
    }
}

