/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.options.Timing;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class RequestImpl
extends ChannelOwner
implements Request {
    private final byte[] postData;
    private RequestImpl redirectedFrom;
    private RequestImpl redirectedTo;
    final Map<String, String> headers = new HashMap<String, String>();
    String failure;
    Timing timing;

    RequestImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        if (initializer.has("redirectedFrom")) {
            this.redirectedFrom = (RequestImpl)this.connection.getExistingObject(initializer.getAsJsonObject("redirectedFrom").get("guid").getAsString());
            this.redirectedFrom.redirectedTo = this;
        }
        for (JsonElement e : initializer.getAsJsonArray("headers")) {
            JsonObject item = e.getAsJsonObject();
            this.headers.put(item.get("name").getAsString().toLowerCase(), item.get("value").getAsString());
        }
        this.postData = (byte[])(initializer.has("postData") ? Base64.getDecoder().decode(initializer.get("postData").getAsString()) : null);
    }

    @Override
    public String failure() {
        return this.failure;
    }

    @Override
    public Frame frame() {
        return (Frame)this.connection.getExistingObject(this.initializer.getAsJsonObject("frame").get("guid").getAsString());
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public boolean isNavigationRequest() {
        return this.initializer.get("isNavigationRequest").getAsBoolean();
    }

    @Override
    public String method() {
        return this.initializer.get("method").getAsString();
    }

    @Override
    public String postData() {
        if (this.postData == null) {
            return null;
        }
        return new String(this.postData, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] postDataBuffer() {
        return this.postData;
    }

    @Override
    public Request redirectedFrom() {
        return this.redirectedFrom;
    }

    @Override
    public Request redirectedTo() {
        return this.redirectedTo;
    }

    @Override
    public String resourceType() {
        return this.initializer.get("resourceType").getAsString();
    }

    @Override
    public Response response() {
        return this.withLogging("Request.response", () -> {
            JsonObject result = this.sendMessage("response").getAsJsonObject();
            if (!result.has("response")) {
                return null;
            }
            return (Response)this.connection.getExistingObject(result.getAsJsonObject("response").get("guid").getAsString());
        });
    }

    @Override
    public Timing timing() {
        return this.timing;
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    Request finalRequest() {
        return this.redirectedTo != null ? this.redirectedTo.finalRequest() : this;
    }
}

