/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.RequestImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.options.Timing;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class ResponseImpl
extends ChannelOwner
implements Response {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final RequestImpl request;

    ResponseImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        JsonObject item;
        for (JsonElement e : initializer.getAsJsonArray("headers")) {
            item = e.getAsJsonObject();
            this.headers.put(item.get("name").getAsString().toLowerCase(), item.get("value").getAsString());
        }
        this.request = (RequestImpl)this.connection.getExistingObject(initializer.getAsJsonObject("request").get("guid").getAsString());
        this.request.headers.clear();
        for (JsonElement e : initializer.getAsJsonArray("requestHeaders")) {
            item = e.getAsJsonObject();
            this.request.headers.put(item.get("name").getAsString().toLowerCase(), item.get("value").getAsString());
        }
        this.request.timing = (Timing)Serialization.gson().fromJson(initializer.get("timing"), Timing.class);
    }

    @Override
    public byte[] body() {
        return this.withLogging("Response.body", () -> {
            JsonObject json = this.sendMessage("body").getAsJsonObject();
            return Base64.getDecoder().decode(json.get("binary").getAsString());
        });
    }

    @Override
    public String finished() {
        return this.withLogging("Response.finished", () -> {
            JsonObject json = this.sendMessage("finished").getAsJsonObject();
            if (json.has("error")) {
                return json.get("error").getAsString();
            }
            return null;
        });
    }

    @Override
    public Frame frame() {
        return this.request().frame();
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public boolean ok() {
        return this.status() == 0 || this.status() >= 200 && this.status() <= 299;
    }

    @Override
    public RequestImpl request() {
        return this.request;
    }

    @Override
    public int status() {
        return this.initializer.get("status").getAsInt();
    }

    @Override
    public String statusText() {
        return this.initializer.get("statusText").getAsString();
    }

    @Override
    public String text() {
        return new String(this.body(), StandardCharsets.UTF_8);
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }
}

