/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class RouteImpl
extends ChannelOwner
implements Route {
    public RouteImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public void abort(String errorCode) {
        this.withLogging("Route.abort", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("errorCode", errorCode);
            this.sendMessage("abort", params);
        });
    }

    @Override
    public void resume(Route.ResumeOptions options) {
        this.withLogging("Route.resume", () -> this.resumeImpl(options));
    }

    private void resumeImpl(Route.ResumeOptions options) {
        if (options == null) {
            options = new Route.ResumeOptions();
        }
        JsonObject params = new JsonObject();
        if (options.url != null) {
            params.addProperty("url", options.url);
        }
        if (options.method != null) {
            params.addProperty("method", options.method);
        }
        if (options.headers != null) {
            params.add("headers", (JsonElement)Serialization.toProtocol(options.headers));
        }
        if (options.postData != null) {
            byte[] bytes = null;
            if (options.postData instanceof byte[]) {
                bytes = (byte[])options.postData;
            } else if (options.postData instanceof String) {
                bytes = ((String)options.postData).getBytes(StandardCharsets.UTF_8);
            } else {
                throw new PlaywrightException("postData must be either String or byte[], found: " + options.postData.getClass().getName());
            }
            String base64 = Base64.getEncoder().encodeToString(bytes);
            params.addProperty("postData", base64);
        }
        this.sendMessage("continue", params);
    }

    @Override
    public void fulfill(Route.FulfillOptions options) {
        this.withLogging("Route.fulfill", () -> this.fulfillImpl(options));
    }

    private void fulfillImpl(Route.FulfillOptions options) {
        if (options == null) {
            options = new Route.FulfillOptions();
        }
        int status = options.status == null ? 200 : options.status;
        String body = "";
        boolean isBase64 = false;
        int length = 0;
        if (options.path != null) {
            try {
                byte[] buffer = Files.readAllBytes(options.path);
                body = Base64.getEncoder().encodeToString(buffer);
                isBase64 = true;
                length = buffer.length;
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read from file: " + options.path, e);
            }
        } else if (options.body != null) {
            body = options.body;
            isBase64 = false;
            length = body.getBytes().length;
        } else if (options.bodyBytes != null) {
            body = Base64.getEncoder().encodeToString(options.bodyBytes);
            isBase64 = true;
            length = options.bodyBytes.length;
        }
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        if (options.headers != null) {
            for (Map.Entry<String, String> h : options.headers.entrySet()) {
                headers.put(h.getKey().toLowerCase(), h.getValue());
            }
        }
        if (options.contentType != null) {
            headers.put("content-type", options.contentType);
        } else if (options.path != null) {
            headers.put("content-type", Utils.mimeType(options.path));
        }
        if (length != 0 && !headers.containsKey("content-length")) {
            headers.put("content-length", Integer.toString(length));
        }
        JsonObject params = new JsonObject();
        params.addProperty("status", (Number)status);
        params.add("headers", (JsonElement)Serialization.toProtocol(headers));
        params.addProperty("isBase64", Boolean.valueOf(isBase64));
        params.addProperty("body", body);
        this.sendMessage("fulfill", params);
    }

    @Override
    public Request request() {
        return (Request)this.connection.getExistingObject(this.initializer.getAsJsonObject("request").get("guid").getAsString());
    }
}

