/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.Route;
import com.microsoft.playwright.impl.UrlMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class Router {
    private List<RouteInfo> routes = new ArrayList<RouteInfo>();

    Router() {
    }

    void add(UrlMatcher matcher, Consumer<Route> handler) {
        this.routes.add(new RouteInfo(matcher, handler));
    }

    void remove(UrlMatcher matcher, Consumer<Route> handler) {
        this.routes = this.routes.stream().filter(info -> !info.matcher.equals(matcher) || handler != null && info.handler != handler).collect(Collectors.toList());
    }

    int size() {
        return this.routes.size();
    }

    boolean handle(Route route) {
        for (RouteInfo info : this.routes) {
            if (!info.matcher.test(route.request().url())) continue;
            info.handler.accept(route);
            return true;
        }
        return false;
    }

    private static class RouteInfo {
        final UrlMatcher matcher;
        final Consumer<Route> handler;

        RouteInfo(UrlMatcher matcher, Consumer<Route> handler) {
            this.matcher = matcher;
            this.handler = handler;
        }
    }
}

