/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.Channel;
import com.microsoft.playwright.impl.ElementHandleImpl;
import com.microsoft.playwright.impl.JSHandleImpl;
import com.microsoft.playwright.impl.SerializedArgument;
import com.microsoft.playwright.impl.SerializedError;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.options.BrowserChannel;
import com.microsoft.playwright.options.ColorScheme;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.KeyboardModifier;
import com.microsoft.playwright.options.LoadState;
import com.microsoft.playwright.options.Media;
import com.microsoft.playwright.options.MouseButton;
import com.microsoft.playwright.options.SameSiteAttribute;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.ViewportSize;
import com.microsoft.playwright.options.WaitForSelectorState;
import com.microsoft.playwright.options.WaitUntilState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class Serialization {
    private static Gson gson;

    Serialization() {
    }

    static Gson gson() {
        if (gson == null) {
            gson = new GsonBuilder().registerTypeAdapter(SameSiteAttribute.class, (Object)new SameSiteAdapter().nullSafe()).registerTypeAdapter(BrowserChannel.class, (Object)new BrowserChannelSerializer()).registerTypeAdapter(ColorScheme.class, (Object)new ColorSchemeAdapter().nullSafe()).registerTypeAdapter(Media.class, (Object)new MediaSerializer()).registerTypeAdapter(ScreenshotType.class, new ToLowerCaseSerializer()).registerTypeAdapter(MouseButton.class, new ToLowerCaseSerializer()).registerTypeAdapter(LoadState.class, new ToLowerCaseSerializer()).registerTypeAdapter(WaitUntilState.class, new ToLowerCaseSerializer()).registerTypeAdapter(WaitForSelectorState.class, new ToLowerCaseSerializer()).registerTypeAdapter(new TypeToken<List<KeyboardModifier>>(){}.getType(), (Object)new KeyboardModifiersSerializer()).registerTypeAdapter(Optional.class, (Object)new OptionalSerializer()).registerTypeHierarchyAdapter(JSHandleImpl.class, (Object)new HandleSerializer()).registerTypeAdapter(new TypeToken<Map<String, String>>(){}.getType(), (Object)new StringMapSerializer()).registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), (Object)new FirefoxUserPrefsSerializer()).registerTypeHierarchyAdapter(Path.class, (Object)new PathSerializer()).create();
        }
        return gson;
    }

    static SerializedError serializeError(Throwable e) {
        SerializedError result = new SerializedError();
        result.error = new SerializedError.Error();
        result.error.message = e.getMessage();
        result.error.name = e.getClass().getName();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(out));
        result.error.stack = new String(out.toByteArray(), StandardCharsets.UTF_8);
        return result;
    }

    private static SerializedValue serializeValue(Object value, List<JSHandleImpl> handles, int depth) {
        if (depth > 100) {
            throw new PlaywrightException("Maximum argument depth exceeded");
        }
        SerializedValue result = new SerializedValue();
        if (value instanceof JSHandleImpl) {
            result.h = handles.size();
            handles.add((JSHandleImpl)value);
            return result;
        }
        if (value == null) {
            result.v = "undefined";
        } else if (value instanceof Double) {
            double d = (Double)value;
            if (d == Double.POSITIVE_INFINITY) {
                result.v = "Infinity";
            } else if (d == Double.NEGATIVE_INFINITY) {
                result.v = "-Infinity";
            } else if (d == 0.0) {
                result.v = "-0";
            } else if (Double.isNaN(d)) {
                result.v = "NaN";
            } else {
                result.n = d;
            }
        } else if (value instanceof Boolean) {
            result.b = (Boolean)value;
        } else if (value instanceof Integer) {
            result.n = (Integer)value;
        } else if (value instanceof String) {
            result.s = (String)value;
        } else if (value instanceof List) {
            ArrayList<SerializedValue> list = new ArrayList<SerializedValue>();
            for (Object o : (List)value) {
                list.add(Serialization.serializeValue(o, handles, depth + 1));
            }
            result.a = list.toArray(new SerializedValue[0]);
        } else if (value instanceof Map) {
            ArrayList<SerializedValue.O> list = new ArrayList<SerializedValue.O>();
            Map map = (Map)value;
            for (Map.Entry e : map.entrySet()) {
                SerializedValue.O o = new SerializedValue.O();
                o.k = (String)e.getKey();
                o.v = Serialization.serializeValue(e.getValue(), handles, depth + 1);
                list.add(o);
            }
            result.o = list.toArray(new SerializedValue.O[0]);
        } else if (value instanceof Object[]) {
            ArrayList<SerializedValue> list = new ArrayList<SerializedValue>();
            for (Object o : (Object[])value) {
                list.add(Serialization.serializeValue(o, handles, depth + 1));
            }
            result.a = list.toArray(new SerializedValue[0]);
        } else {
            throw new PlaywrightException("Unsupported type of argument: " + value);
        }
        return result;
    }

    static SerializedArgument serializeArgument(Object arg) {
        SerializedArgument result = new SerializedArgument();
        ArrayList<JSHandleImpl> handles = new ArrayList<JSHandleImpl>();
        result.value = Serialization.serializeValue(arg, handles, 0);
        result.handles = new Channel[handles.size()];
        int i = 0;
        for (JSHandleImpl handle : handles) {
            result.handles[i] = new Channel();
            result.handles[i].guid = handle.guid;
            ++i;
        }
        return result;
    }

    static <T> T deserialize(SerializedValue value) {
        if (value.n != null) {
            if (value.n.doubleValue() == (double)value.n.intValue()) {
                return (T)Integer.valueOf(value.n.intValue());
            }
            return (T)Double.valueOf(value.n.doubleValue());
        }
        if (value.b != null) {
            return (T)value.b;
        }
        if (value.s != null) {
            return (T)value.s;
        }
        if (value.v != null) {
            switch (value.v) {
                case "undefined": 
                case "null": {
                    return null;
                }
                case "Infinity": {
                    return (T)Double.valueOf(Double.POSITIVE_INFINITY);
                }
                case "-Infinity": {
                    return (T)Double.valueOf(Double.NEGATIVE_INFINITY);
                }
                case "-0": {
                    return (T)Double.valueOf(-0.0);
                }
                case "NaN": {
                    return (T)Double.valueOf(Double.NaN);
                }
            }
            throw new PlaywrightException("Unexpected value: " + value.v);
        }
        if (value.a != null) {
            ArrayList<T> list = new ArrayList<T>();
            for (SerializedValue v : value.a) {
                list.add(Serialization.deserialize(v));
            }
            return (T)list;
        }
        if (value.o != null) {
            LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
            for (SerializedValue.O o : value.o) {
                map.put(o.k, Serialization.deserialize(o.v));
            }
            return (T)map;
        }
        throw new PlaywrightException("Unexpected result: " + Serialization.gson().toJson((Object)value));
    }

    static JsonArray toJsonArray(FilePayload[] files) {
        JsonArray jsonFiles = new JsonArray();
        for (FilePayload p : files) {
            JsonObject jsonFile = new JsonObject();
            jsonFile.addProperty("name", p.name);
            jsonFile.addProperty("mimeType", p.mimeType);
            jsonFile.addProperty("buffer", Base64.getEncoder().encodeToString(p.buffer));
            jsonFiles.add((JsonElement)jsonFile);
        }
        return jsonFiles;
    }

    static JsonArray toProtocol(ElementHandle[] handles) {
        JsonArray jsonElements = new JsonArray();
        for (ElementHandle handle : handles) {
            JsonObject jsonHandle = new JsonObject();
            jsonHandle.addProperty("guid", ((ElementHandleImpl)handle).guid);
            jsonElements.add((JsonElement)jsonHandle);
        }
        return jsonElements;
    }

    static JsonArray toProtocol(Map<String, String> map) {
        JsonArray array = new JsonArray();
        for (Map.Entry<String, String> e : map.entrySet()) {
            JsonObject item = new JsonObject();
            item.addProperty("name", e.getKey());
            item.addProperty("value", e.getValue());
            array.add((JsonElement)item);
        }
        return array;
    }

    static List<String> parseStringList(JsonArray array) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonElement e : array) {
            result.add(e.getAsString());
        }
        return result;
    }

    private static class ColorSchemeAdapter
    extends TypeAdapter<ColorScheme> {
        private ColorSchemeAdapter() {
        }

        public void write(JsonWriter out, ColorScheme value) throws IOException {
            String stringValue;
            switch (value) {
                case DARK: {
                    stringValue = "dark";
                    break;
                }
                case LIGHT: {
                    stringValue = "light";
                    break;
                }
                case NO_PREFERENCE: {
                    stringValue = "no-preference";
                    break;
                }
                default: {
                    throw new PlaywrightException("Unexpected value: " + (Object)((Object)value));
                }
            }
            out.value(stringValue);
        }

        public ColorScheme read(JsonReader in) throws IOException {
            String value;
            switch (value = in.nextString()) {
                case "dark": {
                    return ColorScheme.DARK;
                }
                case "light": {
                    return ColorScheme.LIGHT;
                }
                case "no-preference": {
                    return ColorScheme.NO_PREFERENCE;
                }
            }
            throw new PlaywrightException("Unexpected value: " + value);
        }
    }

    private static class SameSiteAdapter
    extends TypeAdapter<SameSiteAttribute> {
        private SameSiteAdapter() {
        }

        public void write(JsonWriter out, SameSiteAttribute value) throws IOException {
            String stringValue;
            switch (value) {
                case STRICT: {
                    stringValue = "Strict";
                    break;
                }
                case LAX: {
                    stringValue = "Lax";
                    break;
                }
                case NONE: {
                    stringValue = "None";
                    break;
                }
                default: {
                    throw new PlaywrightException("Unexpected value: " + (Object)((Object)value));
                }
            }
            out.value(stringValue);
        }

        public SameSiteAttribute read(JsonReader in) throws IOException {
            String value = in.nextString();
            return SameSiteAttribute.valueOf(value.toUpperCase());
        }
    }

    private static class ToLowerCaseSerializer<E extends Enum<E>>
    implements JsonSerializer<E> {
        private ToLowerCaseSerializer() {
        }

        public JsonElement serialize(E src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).toString().toLowerCase());
        }
    }

    private static class PathSerializer
    implements JsonSerializer<Path> {
        private PathSerializer() {
        }

        public JsonElement serialize(Path src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    private static class MediaSerializer
    implements JsonSerializer<Media> {
        private MediaSerializer() {
        }

        public JsonElement serialize(Media src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString().toLowerCase());
        }
    }

    private static class BrowserChannelSerializer
    implements JsonSerializer<BrowserChannel> {
        private BrowserChannelSerializer() {
        }

        public JsonElement serialize(BrowserChannel src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString().toLowerCase().replace('_', '-'));
        }
    }

    private static class StringMapSerializer
    implements JsonSerializer<Map<String, String>> {
        private StringMapSerializer() {
        }

        public JsonElement serialize(Map<String, String> src, Type typeOfSrc, JsonSerializationContext context) {
            if (!"java.util.Map<java.lang.String, java.lang.String>".equals(typeOfSrc.getTypeName())) {
                throw new PlaywrightException("Unexpected map type: " + typeOfSrc);
            }
            return Serialization.toProtocol(src);
        }
    }

    private static class FirefoxUserPrefsSerializer
    implements JsonSerializer<Map<String, Object>> {
        private FirefoxUserPrefsSerializer() {
        }

        public JsonElement serialize(Map<String, Object> src, Type typeOfSrc, JsonSerializationContext context) {
            if (!"java.util.Map<java.lang.String, java.lang.Object>".equals(typeOfSrc.getTypeName())) {
                throw new PlaywrightException("Unexpected map type: " + typeOfSrc);
            }
            return context.serialize(src, Map.class);
        }
    }

    private static class HandleSerializer
    implements JsonSerializer<JSHandleImpl> {
        private HandleSerializer() {
        }

        public JsonElement serialize(JSHandleImpl src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("guid", src.guid);
            return json;
        }
    }

    private static class OptionalSerializer
    implements JsonSerializer<Optional<?>> {
        private OptionalSerializer() {
        }

        private static boolean isSupported(Type type) {
            return new TypeToken<Optional<Media>>(){}.getType().getTypeName().equals(type.getTypeName()) || new TypeToken<Optional<ColorScheme>>(){}.getType().getTypeName().equals(type.getTypeName()) || new TypeToken<Optional<ViewportSize>>(){}.getType().getTypeName().equals(type.getTypeName());
        }

        public JsonElement serialize(Optional<?> src, Type typeOfSrc, JsonSerializationContext context) {
            assert (OptionalSerializer.isSupported(typeOfSrc)) : "Unexpected optional type: " + typeOfSrc.getTypeName();
            if (!src.isPresent()) {
                return new JsonPrimitive("null");
            }
            return context.serialize(src.get());
        }
    }

    private static class KeyboardModifiersSerializer
    implements JsonSerializer<List<KeyboardModifier>> {
        private KeyboardModifiersSerializer() {
        }

        public JsonArray serialize(List<KeyboardModifier> modifiers, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            if (modifiers.contains((Object)KeyboardModifier.ALT)) {
                result.add("Alt");
            }
            if (modifiers.contains((Object)KeyboardModifier.CONTROL)) {
                result.add("Control");
            }
            if (modifiers.contains((Object)KeyboardModifier.META)) {
                result.add("Meta");
            }
            if (modifiers.contains((Object)KeyboardModifier.SHIFT)) {
                result.add("Shift");
            }
            return result;
        }
    }
}

