/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.options.FilePayload;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;

class Utils {
    static Set<Character> escapeGlobChars = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('$'), Character.valueOf('^'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('|')));

    Utils() {
    }

    static <F, T> T convertViaJson(F f, Class<T> t) {
        Gson gson = new GsonBuilder().registerTypeAdapter(Optional.class, (Object)new OptionalSerializer()).create();
        String json = gson.toJson(f);
        return (T)gson.fromJson(json, t);
    }

    static String globToRegex(String glob) {
        StringBuilder tokens = new StringBuilder();
        tokens.append('^');
        boolean inGroup = false;
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (escapeGlobChars.contains(Character.valueOf(c))) {
                tokens.append("\\" + c);
                continue;
            }
            if (c == '*') {
                boolean isDeep;
                boolean beforeDeep = i < 1 || glob.charAt(i - 1) == '/';
                int starCount = 1;
                while (i + 1 < glob.length() && glob.charAt(i + 1) == '*') {
                    ++starCount;
                    ++i;
                }
                boolean afterDeep = i + 1 >= glob.length() || glob.charAt(i + 1) == '/';
                boolean bl = isDeep = starCount > 1 && beforeDeep && afterDeep;
                if (isDeep) {
                    tokens.append("((?:[^/]*(?:\\/|$))*)");
                    ++i;
                    continue;
                }
                tokens.append("([^/]*)");
                continue;
            }
            switch (c) {
                case '?': {
                    tokens.append('.');
                    continue block6;
                }
                case '{': {
                    inGroup = true;
                    tokens.append('(');
                    continue block6;
                }
                case '}': {
                    inGroup = false;
                    tokens.append(')');
                    continue block6;
                }
                case ',': {
                    if (inGroup) {
                        tokens.append('|');
                        continue block6;
                    }
                    tokens.append("\\" + c);
                    continue block6;
                }
                default: {
                    tokens.append(c);
                }
            }
        }
        tokens.append('$');
        return tokens.toString();
    }

    static String mimeType(Path path) {
        String mimeType;
        try {
            mimeType = Files.probeContentType(path);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to determine mime type", e);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    static FilePayload[] toFilePayloads(Path[] files) {
        ArrayList<FilePayload> payloads = new ArrayList<FilePayload>();
        for (Path file : files) {
            byte[] buffer;
            try {
                buffer = Files.readAllBytes(file);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read from file", e);
            }
            payloads.add(new FilePayload(file.getFileName().toString(), Utils.mimeType(file), buffer));
        }
        return payloads.toArray(new FilePayload[0]);
    }

    static void mkParentDirs(Path file) {
        Path dir = file.getParent();
        if (dir != null && !Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to create parent directory: " + dir.toString(), e);
            }
        }
    }

    static void writeToFile(byte[] buffer, Path path) {
        Utils.mkParentDirs(path);
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            out.write(buffer);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to write to file", e);
        }
    }

    static void writeToFile(InputStream inputStream, Path path) {
        Utils.mkParentDirs(path);
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            int length;
            byte[] buf = new byte[8192];
            while ((length = inputStream.read(buf)) > 0) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to write to file", e);
        }
    }

    static boolean isSafeCloseError(PlaywrightException exception) {
        return Utils.isSafeCloseError(exception.getMessage());
    }

    static boolean isSafeCloseError(String error) {
        return error.endsWith("Browser has been closed") || error.endsWith("Target page, context or browser has been closed");
    }

    static String createGuid() {
        StringBuffer result = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 4; ++i) {
            result.append(Integer.toHexString(random.nextInt()));
        }
        return result.toString();
    }

    private static class OptionalSerializer
    implements JsonSerializer<Optional> {
        private OptionalSerializer() {
        }

        public JsonElement serialize(Optional src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            if (src.isPresent()) {
                result.add("value", context.serialize(src.get()));
            }
            return result;
        }
    }
}

