/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.TimeoutError;
import com.microsoft.playwright.impl.Waitable;

class WaitableResult<T>
implements Waitable<T> {
    private T result;
    private RuntimeException exception;
    private boolean isDone;

    WaitableResult() {
    }

    void complete(T result) {
        if (this.isDone) {
            return;
        }
        this.result = result;
        this.isDone = true;
    }

    void completeExceptionally(RuntimeException exception) {
        if (this.isDone) {
            return;
        }
        this.exception = exception;
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public T get() {
        if (this.exception != null) {
            if (this.exception instanceof TimeoutError) {
                throw new TimeoutError(this.exception.getMessage(), this.exception);
            }
            throw new PlaywrightException(this.exception.getMessage(), this.exception);
        }
        return this.result;
    }

    @Override
    public void dispose() {
    }
}

