/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.Transport;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

class WebSocketTransport
implements Transport {
    private final BlockingQueue<String> incoming = new LinkedBlockingQueue<String>();
    private final ClientConnection clientConnection;
    private boolean isClosed;
    private volatile Exception lastError;
    ListenerCollection<EventType> listeners = new ListenerCollection();

    WebSocketTransport(URI uri, Map<String, String> headers, Duration timeout) {
        this.clientConnection = new ClientConnection(uri);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.clientConnection.addHeader(entry.getKey(), entry.getValue());
        }
        try {
            if (!this.clientConnection.connectBlocking(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new PlaywrightException("Failed to connect", this.lastError);
            }
        }
        catch (InterruptedException e) {
            throw new PlaywrightException("Failed to connect", e);
        }
    }

    @Override
    public void send(String message) {
        this.checkIfClosed();
        this.clientConnection.send(message);
    }

    @Override
    public String poll(Duration timeout) {
        this.checkIfClosed();
        try {
            return this.incoming.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new PlaywrightException("Failed to read message", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.clientConnection.close();
    }

    void onClose(Consumer<WebSocketTransport> handler) {
        this.listeners.add(EventType.CLOSE, handler);
    }

    void offClose(Consumer<WebSocketTransport> handler) {
        this.listeners.remove(EventType.CLOSE, handler);
    }

    private void checkIfClosed() {
        if (this.isClosed) {
            throw new PlaywrightException("Playwright connection closed");
        }
        if (this.clientConnection.isClosed()) {
            this.isClosed = true;
            this.listeners.notify(EventType.CLOSE, this);
            throw new PlaywrightException("Playwright connection closed");
        }
    }

    private class ClientConnection
    extends WebSocketClient {
        ClientConnection(URI serverUri) {
            super(serverUri);
        }

        public void onOpen(ServerHandshake handshakedata) {
        }

        public void onMessage(String message) {
            WebSocketTransport.this.incoming.add(message);
        }

        public void onClose(int code, String reason, boolean remote) {
        }

        public void onError(Exception ex) {
            WebSocketTransport.this.lastError = ex;
        }
    }

    private static enum EventType {
        CLOSE;

    }
}

