/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.impl.LocalUtils;
import com.microsoft.playwright.impl.LoggingSupport;
import com.microsoft.playwright.impl.RouteImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.options.HarNotFound;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;

public class HARRouter {
    private final LocalUtils localUtils;
    private final HarNotFound defaultAction;
    private final String harId;

    HARRouter(LocalUtils localUtils, Path harFile, HarNotFound defaultAction) {
        this.localUtils = localUtils;
        this.defaultAction = defaultAction;
        JsonObject params = new JsonObject();
        params.addProperty("file", harFile.toString());
        JsonObject json = localUtils.sendMessage("harOpen", params).getAsJsonObject();
        if (json.has("error")) {
            throw new PlaywrightException(json.get("error").getAsString());
        }
        this.harId = json.get("harId").getAsString();
    }

    void handle(Route route) {
        Request request = route.request();
        JsonObject params = new JsonObject();
        params.addProperty("harId", this.harId);
        params.addProperty("url", request.url());
        params.addProperty("method", request.method());
        params.add("headers", Serialization.gson().toJsonTree(request.headersArray()));
        if (request.postDataBuffer() != null) {
            String base64 = Base64.getEncoder().encodeToString(request.postDataBuffer());
            params.addProperty("postData", base64);
        }
        params.addProperty("isNavigationRequest", Boolean.valueOf(request.isNavigationRequest()));
        JsonObject response = this.localUtils.sendMessage("harLookup", params).getAsJsonObject();
        String action = response.get("action").getAsString();
        if ("redirect".equals(action)) {
            String redirectURL = response.get("redirectURL").getAsString();
            LoggingSupport.logApiIfEnabled("HAR: " + route.request().url() + " redirected to " + redirectURL);
            ((RouteImpl)route).redirectNavigationRequest(redirectURL);
            return;
        }
        if ("fulfill".equals(action)) {
            int status = response.get("status").getAsInt();
            Map<String, String> headers = Serialization.fromNameValues(response.getAsJsonArray("headers"));
            byte[] buffer = Base64.getDecoder().decode(response.get("body").getAsString());
            route.fulfill(new Route.FulfillOptions().setStatus(status).setHeaders(headers).setBodyBytes(buffer));
            return;
        }
        if ("error".equals(action)) {
            LoggingSupport.logApiIfEnabled("HAR: " + response.get("message").getAsString());
        }
        if (this.defaultAction == HarNotFound.FALLBACK) {
            route.fallback();
            return;
        }
        route.abort();
    }

    void dispose() {
        JsonObject params = new JsonObject();
        params.addProperty("harId", this.harId);
        this.localUtils.sendMessageAsync("harClose", params);
    }
}

