/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.Locator;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.AriaRole;
import java.util.regex.Pattern;

public class LocatorUtils {
    private static volatile String testIdAttributeName = "data-testid";

    static void setTestIdAttributeName(String name) {
        testIdAttributeName = name;
    }

    static String getByTextSelector(Object text, Locator.GetByTextOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return "internal:text=" + LocatorUtils.escapeForTextSelector(text, exact);
    }

    static String getByLabelSelector(Object text, Locator.GetByLabelOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return "internal:label=" + LocatorUtils.escapeForTextSelector(text, exact);
    }

    private static String getByAttributeTextSelector(String attrName, Object value, boolean exact) {
        if (value instanceof Pattern) {
            return "internal:attr=[" + attrName + "=" + LocatorUtils.toJsRegExp((Pattern)value) + "]";
        }
        return "internal:attr=[" + attrName + "=" + LocatorUtils.escapeForAttributeSelector((String)value, exact) + "]";
    }

    static String getByTestIdSelector(String testId) {
        return LocatorUtils.getByAttributeTextSelector(testIdAttributeName, testId, true);
    }

    static String getByAltTextSelector(Object text, Locator.GetByAltTextOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return LocatorUtils.getByAttributeTextSelector("alt", text, exact);
    }

    static String getByTitleSelector(Object text, Locator.GetByTitleOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return LocatorUtils.getByAttributeTextSelector("title", text, exact);
    }

    static String getByPlaceholderSelector(Object text, Locator.GetByPlaceholderOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return LocatorUtils.getByAttributeTextSelector("placeholder", text, exact);
    }

    private static void addAttr(StringBuilder result, String name, String value) {
        result.append("[").append(name).append("=").append(value).append("]");
    }

    static String getByRoleSelector(AriaRole role, Locator.GetByRoleOptions options) {
        StringBuilder result = new StringBuilder();
        result.append("internal:role=").append(role.name().toLowerCase());
        if (options != null) {
            if (options.checked != null) {
                LocatorUtils.addAttr(result, "checked", options.checked.toString());
            }
            if (options.disabled != null) {
                LocatorUtils.addAttr(result, "disabled", options.disabled.toString());
            }
            if (options.selected != null) {
                LocatorUtils.addAttr(result, "selected", options.selected.toString());
            }
            if (options.expanded != null) {
                LocatorUtils.addAttr(result, "expanded", options.expanded.toString());
            }
            if (options.includeHidden != null) {
                LocatorUtils.addAttr(result, "include-hidden", options.includeHidden.toString());
            }
            if (options.level != null) {
                LocatorUtils.addAttr(result, "level", options.level.toString());
            }
            if (options.name != null) {
                String name;
                if (options.name instanceof String) {
                    name = LocatorUtils.escapeForAttributeSelector((String)options.name, options.exact != null && options.exact != false);
                } else if (options.name instanceof Pattern) {
                    name = LocatorUtils.toJsRegExp((Pattern)options.name);
                } else {
                    throw new IllegalArgumentException("options.name can be String or Pattern, found: " + options.name);
                }
                LocatorUtils.addAttr(result, "name", name);
            }
            if (options.pressed != null) {
                LocatorUtils.addAttr(result, "pressed", options.pressed.toString());
            }
        }
        return result.toString();
    }

    static String escapeForTextSelector(Object text, boolean exact) {
        return LocatorUtils.escapeForTextSelector(text, exact, false);
    }

    private static String escapeForTextSelector(Object param, boolean exact, boolean caseSensitive) {
        if (param instanceof Pattern) {
            return LocatorUtils.toJsRegExp((Pattern)param);
        }
        if (!(param instanceof String)) {
            throw new IllegalArgumentException("text parameter must be Pattern or String: " + param);
        }
        String text = (String)param;
        if (exact) {
            return '\"' + text.replace("\"", "\\\"") + '\"';
        }
        if (text.contains("\"") || text.contains(">>") || text.startsWith("/")) {
            return "/" + LocatorUtils.escapeForRegex(text).replaceAll("\\s+", "\\\\s+") + "/" + (caseSensitive ? "" : "i");
        }
        return text;
    }

    private static String escapeForRegex(String text) {
        return text.replaceAll("[.*+?^>${}()|\\[\\]\\\\]", "\\\\\\\\$0");
    }

    private static String escapeForAttributeSelector(String value, boolean exact) {
        return '\"' + value.replaceAll("\"", "\\\\\"") + '\"' + (exact ? "" : "i");
    }

    private static String toJsRegExp(Pattern pattern) {
        return "/" + pattern.pattern() + "/" + Utils.toJsRegexFlags(pattern);
    }
}

