/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.Route;
import com.microsoft.playwright.impl.RouteImpl;
import com.microsoft.playwright.impl.UrlMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class Router {
    private List<RouteInfo> routes = new ArrayList<RouteInfo>();

    Router() {
    }

    void add(UrlMatcher matcher, Consumer<Route> handler, Integer times) {
        this.routes.add(0, new RouteInfo(matcher, handler, times));
    }

    void remove(UrlMatcher matcher, Consumer<Route> handler) {
        this.routes = this.routes.stream().filter(info -> !info.matcher.equals(matcher) || handler != null && info.handler != handler).collect(Collectors.toList());
    }

    int size() {
        return this.routes.size();
    }

    HandleResult handle(RouteImpl route) {
        HandleResult result = HandleResult.NoMatchingHandler;
        Iterator<RouteInfo> it = this.routes.iterator();
        while (it.hasNext()) {
            RouteInfo info = it.next();
            if (!info.matcher.test(route.request().url())) continue;
            if (info.decrementRemainingCallCount()) {
                it.remove();
            }
            result = HandleResult.FoundMatchingHandler;
            info.handle(route);
            if (!route.isHandled()) continue;
            break;
        }
        return result;
    }

    static enum HandleResult {
        NoMatchingHandler,
        FoundMatchingHandler;

    }

    private static class RouteInfo {
        final UrlMatcher matcher;
        final Consumer<Route> handler;
        Integer times;

        RouteInfo(UrlMatcher matcher, Consumer<Route> handler, Integer times) {
            this.matcher = matcher;
            this.handler = handler;
            this.times = times;
        }

        void handle(RouteImpl route) {
            this.handler.accept(route);
        }

        boolean decrementRemainingCallCount() {
            if (this.times == null) {
                return false;
            }
            this.times = this.times - 1;
            return this.times <= 0;
        }
    }
}

