/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class StackTraceCollector {
    static final String PLAYWRIGHT_JAVA_SRC = "PLAYWRIGHT_JAVA_SRC";
    private final List<Path> srcDirs;
    private final Map<Path, String> classToSourceCache = new HashMap<Path, String>();

    static StackTraceCollector createFromEnv(Map<String, String> env) {
        String srcRoots = null;
        if (env != null) {
            srcRoots = env.get(PLAYWRIGHT_JAVA_SRC);
        }
        if (srcRoots == null) {
            srcRoots = System.getenv(PLAYWRIGHT_JAVA_SRC);
        }
        if (srcRoots == null) {
            return null;
        }
        List<Path> srcDirs = Arrays.stream(srcRoots.split(File.pathSeparator)).map(p -> Paths.get(p, new String[0])).collect(Collectors.toList());
        for (Path srcDir : srcDirs) {
            if (Files.exists(srcDir.toAbsolutePath(), new LinkOption[0])) continue;
            throw new PlaywrightException("Source location specified in PLAYWRIGHT_JAVA_SRC doesn't exist: '" + srcDir.toAbsolutePath() + "'");
        }
        return new StackTraceCollector(srcDirs);
    }

    private StackTraceCollector(List<Path> srcDirs) {
        this.srcDirs = srcDirs;
    }

    private String sourceFile(StackTraceElement frame) {
        String pkg = frame.getClassName();
        int lastDot = pkg.lastIndexOf(46);
        pkg = lastDot == -1 ? "" : frame.getClassName().substring(0, lastDot + 1);
        pkg = pkg.replace('.', File.separatorChar);
        String file = frame.getFileName();
        if (file == null) {
            return "";
        }
        try {
            return this.resolveSourcePath(Paths.get(pkg, new String[0]).resolve(file));
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    private String resolveSourcePath(Path relativePath) {
        String path = this.classToSourceCache.get(relativePath);
        if (path == null) {
            for (Path dir : this.srcDirs) {
                Path absolutePath = dir.resolve(relativePath);
                if (!Files.exists(absolutePath, new LinkOption[0])) continue;
                path = absolutePath.toString();
                this.classToSourceCache.put(relativePath, path);
                break;
            }
            if (path == null) {
                path = "";
                this.classToSourceCache.put(relativePath, path);
            }
        }
        return path;
    }

    JsonArray currentStackTrace() {
        int index;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (index = 0; index < stack.length && !stack[index].getClassName().equals(this.getClass().getName()); ++index) {
        }
        while (index < stack.length && stack[index].getClassName().startsWith("com.microsoft.playwright.") && !stack[index].getClassName().startsWith("com.microsoft.playwright.Test")) {
            ++index;
        }
        JsonArray jsonStack = new JsonArray();
        while (index < stack.length) {
            StackTraceElement frame = stack[index];
            JsonObject jsonFrame = new JsonObject();
            jsonFrame.addProperty("file", this.sourceFile(frame));
            jsonFrame.addProperty("line", (Number)frame.getLineNumber());
            jsonFrame.addProperty("function", frame.getClassName() + "." + frame.getMethodName());
            jsonStack.add((JsonElement)jsonFrame);
            ++index;
        }
        return jsonStack;
    }
}

