/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Tracing;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import java.nio.file.Path;

class TracingImpl
extends ChannelOwner
implements Tracing {
    TracingImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    private void stopChunkImpl(Path path) {
        JsonObject params = new JsonObject();
        String mode = "doNotSave";
        if (path != null) {
            mode = this.connection.isRemote ? "compressTrace" : "compressTraceAndSources";
        }
        params.addProperty("mode", mode);
        JsonObject json = this.sendMessage("tracingStopChunk", params).getAsJsonObject();
        if (!json.has("artifact")) {
            return;
        }
        ArtifactImpl artifact = (ArtifactImpl)this.connection.getExistingObject(json.getAsJsonObject("artifact").get("guid").getAsString());
        artifact.saveAs(path);
        artifact.delete();
        if (this.connection.isRemote && json.has("sourceEntries")) {
            JsonArray entries = json.getAsJsonArray("sourceEntries");
            this.connection.localUtils.zip(path, entries);
        }
    }

    @Override
    public void start(Tracing.StartOptions options) {
        this.withLogging("Tracing.start", () -> this.startImpl(options));
    }

    @Override
    public void startChunk(Tracing.StartChunkOptions options) {
        this.withLogging("Tracing.startChunk", () -> this.startChunkImpl(options));
    }

    private void startChunkImpl(Tracing.StartChunkOptions options) {
        if (options == null) {
            options = new Tracing.StartChunkOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("tracingStartChunk", params);
    }

    private void startImpl(Tracing.StartOptions options) {
        boolean includeSources;
        if (options == null) {
            options = new Tracing.StartOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        boolean bl = includeSources = options.sources != null && options.sources != false;
        if (includeSources) {
            if (!this.connection.isCollectingStacks()) {
                throw new PlaywrightException("Source root directory must be specified via PLAYWRIGHT_JAVA_SRC environment variable when source collection is enabled");
            }
            params.addProperty("sources", Boolean.valueOf(true));
        }
        this.sendMessage("tracingStart", params);
        this.sendMessage("tracingStartChunk");
    }

    @Override
    public void stop(Tracing.StopOptions options) {
        this.withLogging("Tracing.stop", () -> {
            this.stopChunkImpl(options == null ? null : options.path);
            this.sendMessage("tracingStop");
        });
    }

    @Override
    public void stopChunk(Tracing.StopChunkOptions options) {
        this.withLogging("Tracing.stopChunk", () -> this.stopChunkImpl(options == null ? null : options.path));
    }
}

