/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.microsoft.playwright.APIRequestContext;
import com.microsoft.playwright.APIResponse;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.impl.APIResponseImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.RequestOptionsImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.TracingImpl;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.RequestOptions;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

class APIRequestContextImpl
extends ChannelOwner
implements APIRequestContext {
    private final TracingImpl tracing;

    APIRequestContextImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.tracing = (TracingImpl)this.connection.getExistingObject(initializer.getAsJsonObject("tracing").get("guid").getAsString());
    }

    @Override
    public APIResponse delete(String url, RequestOptions options) {
        return this.fetch(url, (RequestOptions)APIRequestContextImpl.ensureOptions(options, "DELETE"));
    }

    @Override
    public void dispose() {
        this.withLogging("APIRequestContext.dispose", () -> this.sendMessage("dispose"));
    }

    @Override
    public APIResponse fetch(String urlOrRequest, RequestOptions options) {
        return this.withLogging("APIRequestContext.fetch", () -> this.fetchImpl(urlOrRequest, (RequestOptionsImpl)options));
    }

    @Override
    public APIResponse fetch(Request request, RequestOptions optionsArg) {
        RequestOptionsImpl options = (RequestOptionsImpl)optionsArg;
        if (options == null) {
            options = new RequestOptionsImpl();
        }
        if (options.method == null) {
            options.method = request.method();
        }
        if (options.headers == null) {
            options.headers = request.headers();
        }
        if (options.data == null && options.form == null && options.multipart == null) {
            options.data = request.postDataBuffer();
        }
        return this.fetch(request.url(), (RequestOptions)options);
    }

    private APIResponse fetchImpl(String url, RequestOptionsImpl options) {
        if (options == null) {
            options = new RequestOptionsImpl();
        }
        JsonObject params = new JsonObject();
        params.addProperty("url", url);
        if (options.params != null) {
            LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> e : options.params.entrySet()) {
                queryParams.put(e.getKey(), "" + e.getValue());
            }
            params.add("params", (JsonElement)Serialization.toNameValueArray(queryParams));
        }
        if (options.method != null) {
            params.addProperty("method", options.method);
        }
        if (options.headers != null) {
            params.add("headers", (JsonElement)Serialization.toProtocol(options.headers));
        }
        if (options.data != null) {
            byte[] bytes = null;
            if (options.data instanceof byte[]) {
                bytes = (byte[])options.data;
            } else if (options.data instanceof String) {
                String stringData = (String)options.data;
                if (!APIRequestContextImpl.isJsonContentType(options.headers) || APIRequestContextImpl.isJsonParsable(stringData)) {
                    bytes = stringData.getBytes(StandardCharsets.UTF_8);
                }
            }
            if (bytes == null) {
                params.addProperty("jsonData", Serialization.gson().toJson(options.data));
            } else {
                String base64 = Base64.getEncoder().encodeToString(bytes);
                params.addProperty("postData", base64);
            }
        }
        if (options.form != null) {
            params.add("formData", (JsonElement)Serialization.toNameValueArray(options.form.fields));
        }
        if (options.multipart != null) {
            params.add("multipartData", (JsonElement)APIRequestContextImpl.serializeMultipartData(options.multipart.fields));
        }
        if (options.timeout != null) {
            params.addProperty("timeout", (Number)options.timeout);
        }
        if (options.failOnStatusCode != null) {
            params.addProperty("failOnStatusCode", options.failOnStatusCode);
        }
        if (options.ignoreHTTPSErrors != null) {
            params.addProperty("ignoreHTTPSErrors", options.ignoreHTTPSErrors);
        }
        if (options.maxRedirects != null) {
            if (options.maxRedirects < 0) {
                throw new PlaywrightException("'maxRedirects' should be greater than or equal to '0'");
            }
            params.addProperty("maxRedirects", (Number)options.maxRedirects);
        }
        JsonObject json = this.sendMessage("fetch", params).getAsJsonObject();
        return new APIResponseImpl(this, json.getAsJsonObject("response"));
    }

    private static boolean isJsonContentType(Map<String, String> headers) {
        if (headers == null) {
            return false;
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            if (!"content-type".equalsIgnoreCase(e.getKey())) continue;
            return "application/json".equals(e.getValue());
        }
        return false;
    }

    private static JsonArray serializeMultipartData(Map<String, Object> data) {
        JsonArray result = new JsonArray();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            FilePayload filePayload = null;
            if (e.getValue() instanceof FilePayload) {
                filePayload = (FilePayload)e.getValue();
            } else if (e.getValue() instanceof Path) {
                filePayload = Utils.toFilePayload((Path)e.getValue());
            } else if (e.getValue() instanceof File) {
                filePayload = Utils.toFilePayload(((File)e.getValue()).toPath());
            }
            JsonObject item = new JsonObject();
            item.addProperty("name", e.getKey());
            if (filePayload == null) {
                item.addProperty("value", "" + e.getValue());
            } else {
                item.add("file", (JsonElement)Serialization.toProtocol(filePayload));
            }
            result.add((JsonElement)item);
        }
        return result;
    }

    @Override
    public APIResponse get(String url, RequestOptions options) {
        return this.fetch(url, (RequestOptions)APIRequestContextImpl.ensureOptions(options, "GET"));
    }

    @Override
    public APIResponse head(String url, RequestOptions options) {
        return this.fetch(url, (RequestOptions)APIRequestContextImpl.ensureOptions(options, "HEAD"));
    }

    @Override
    public APIResponse patch(String url, RequestOptions options) {
        return this.fetch(url, (RequestOptions)APIRequestContextImpl.ensureOptions(options, "PATCH"));
    }

    @Override
    public APIResponse post(String url, RequestOptions options) {
        return this.fetch(url, (RequestOptions)APIRequestContextImpl.ensureOptions(options, "POST"));
    }

    @Override
    public APIResponse put(String url, RequestOptions options) {
        return this.fetch(url, (RequestOptions)APIRequestContextImpl.ensureOptions(options, "PUT"));
    }

    @Override
    public String storageState(APIRequestContext.StorageStateOptions options) {
        return this.withLogging("APIRequestContext.storageState", () -> {
            JsonElement json = this.sendMessage("storageState");
            String storageState = json.toString();
            if (options != null && options.path != null) {
                Utils.writeToFile(storageState.getBytes(StandardCharsets.UTF_8), options.path);
            }
            return storageState;
        });
    }

    private static RequestOptionsImpl ensureOptions(RequestOptions options, String method) {
        RequestOptionsImpl impl = Utils.clone((RequestOptionsImpl)options);
        if (impl == null) {
            impl = new RequestOptionsImpl();
        }
        if (impl.method == null) {
            impl.method = method;
        }
        return impl;
    }

    private static boolean isJsonParsable(String value) {
        try {
            JsonPrimitive primitive;
            JsonElement result = JsonParser.parseString((String)value);
            return result == null || !result.isJsonPrimitive() || !(primitive = result.getAsJsonPrimitive()).isString() || !value.equals(primitive.getAsString());
        }
        catch (JsonSyntaxException error) {
            return false;
        }
    }
}

