/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.CDPSession;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import java.util.HashMap;
import java.util.function.Consumer;

public class CDPSessionImpl
extends ChannelOwner
implements CDPSession {
    private final ListenerCollection<String> listeners = new ListenerCollection(new HashMap(), this);

    protected CDPSessionImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    void handleEvent(String event, JsonObject parameters) {
        super.handleEvent(event, parameters);
        if ("event".equals(event)) {
            String method = parameters.get("method").getAsString();
            JsonObject params = parameters.get("params").getAsJsonObject();
            this.listeners.notify(method, params);
        }
    }

    @Override
    public JsonObject send(String method) {
        return this.send(method, null);
    }

    @Override
    public JsonObject send(String method, JsonObject params) {
        JsonObject args = new JsonObject();
        if (params != null) {
            args.add("params", (JsonElement)params);
        }
        args.addProperty("method", method);
        JsonElement response = this.connection.sendMessage(this.guid, "send", args);
        if (response == null) {
            return null;
        }
        return response.getAsJsonObject().get("result").getAsJsonObject();
    }

    @Override
    public void on(String event, Consumer<JsonObject> handler) {
        this.listeners.add(event, handler);
    }

    @Override
    public void off(String event, Consumer<JsonObject> handler) {
        this.listeners.remove(event, handler);
    }

    @Override
    public void detach() {
        this.sendMessage("detach");
    }
}

