/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Video;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.BrowserImpl;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.WaitableRace;
import com.microsoft.playwright.impl.WaitableResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

class VideoImpl
implements Video {
    private final PageImpl page;
    private final WaitableResult<ArtifactImpl> waitableArtifact = new WaitableResult();

    VideoImpl(PageImpl page) {
        this.page = page;
        BrowserImpl browser = page.context().browser();
    }

    void setArtifact(ArtifactImpl artifact) {
        this.waitableArtifact.complete(artifact);
    }

    private ArtifactImpl waitForArtifact() {
        WaitableRace waitable = new WaitableRace(Arrays.asList(this.waitableArtifact, this.page.waitableClosedOrCrashed));
        return (ArtifactImpl)this.page.runUntil(() -> {}, waitable);
    }

    @Override
    public void delete() {
        this.page.withLogging("Video.delete", () -> {
            try {
                this.waitForArtifact().delete();
            }
            catch (PlaywrightException playwrightException) {
                // empty catch block
            }
        });
    }

    @Override
    public Path path() {
        return this.page.withLogging("Video.path", () -> {
            if (this.page.connection.isRemote) {
                throw new PlaywrightException("Path is not available when using browserType.connect(). Use saveAs() to save a local copy.");
            }
            try {
                return Paths.get(this.waitForArtifact().initializer.get("absolutePath").getAsString(), new String[0]);
            }
            catch (PlaywrightException e) {
                throw new PlaywrightException("Page did not produce any video frames", e);
            }
        });
    }

    @Override
    public void saveAs(Path path) {
        this.page.withLogging("Video.saveAs", () -> {
            if (!this.page.isClosed()) {
                throw new PlaywrightException("Page is not yet closed. Close the page prior to calling saveAs");
            }
            try {
                this.waitForArtifact().saveAs(path);
            }
            catch (PlaywrightException e) {
                throw new PlaywrightException("Page did not produce any video frames", e);
            }
        });
    }
}

