/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.junit.impl;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.junit.Options;
import com.microsoft.playwright.junit.impl.BrowserExtension;
import com.microsoft.playwright.junit.impl.DeviceDescriptor;
import com.microsoft.playwright.junit.impl.ExtensionUtils;
import com.microsoft.playwright.junit.impl.OptionsExtension;
import com.microsoft.playwright.junit.impl.PlaywrightExtension;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class BrowserContextExtension
implements ParameterResolver,
AfterEachCallback {
    private static final ThreadLocal<BrowserContext> threadLocalBrowserContext = new ThreadLocal();

    public void afterEach(ExtensionContext extensionContext) {
        BrowserContext browserContext = threadLocalBrowserContext.get();
        threadLocalBrowserContext.remove();
        if (browserContext != null) {
            browserContext.close();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return !ExtensionUtils.isClassHook(extensionContext) && ExtensionUtils.isParameterSupported(parameterContext, extensionContext, BrowserContext.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return BrowserContextExtension.getOrCreateBrowserContext(extensionContext);
    }

    static BrowserContext getOrCreateBrowserContext(ExtensionContext extensionContext) {
        BrowserContext browserContext = threadLocalBrowserContext.get();
        if (browserContext != null) {
            return browserContext;
        }
        Options options = OptionsExtension.getOptions(extensionContext);
        Playwright playwright = PlaywrightExtension.getOrCreatePlaywright(extensionContext);
        ExtensionUtils.setTestIdAttribute(playwright, options);
        Browser browser = BrowserExtension.getOrCreateBrowser(extensionContext);
        Browser.NewContextOptions contextOptions = BrowserContextExtension.getContextOptions(playwright, options);
        browserContext = browser.newContext(contextOptions);
        threadLocalBrowserContext.set(browserContext);
        return browserContext;
    }

    private static Browser.NewContextOptions getContextOptions(Playwright playwright, Options options) {
        Browser.NewContextOptions contextOptions = Utils.clone(options.contextOptions);
        if (contextOptions == null) {
            contextOptions = new Browser.NewContextOptions();
        }
        if (options.baseUrl != null) {
            contextOptions.setBaseURL(options.baseUrl);
        }
        if (options.deviceName != null) {
            DeviceDescriptor deviceDescriptor = DeviceDescriptor.findByName(playwright, options.deviceName);
            if (deviceDescriptor == null) {
                throw new PlaywrightException("Unknown device name: " + options.deviceName);
            }
            contextOptions.userAgent = deviceDescriptor.userAgent;
            if (deviceDescriptor.viewport != null) {
                contextOptions.setViewportSize(deviceDescriptor.viewport.width, deviceDescriptor.viewport.height);
            }
            contextOptions.deviceScaleFactor = deviceDescriptor.deviceScaleFactor;
            contextOptions.isMobile = deviceDescriptor.isMobile;
            contextOptions.hasTouch = deviceDescriptor.hasTouch;
        }
        if (options.ignoreHTTPSErrors != null) {
            contextOptions.setIgnoreHTTPSErrors(options.ignoreHTTPSErrors);
        }
        return contextOptions;
    }
}

