/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.junit.impl;

import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.junit.Options;
import com.microsoft.playwright.junit.UsePlaywright;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.platform.commons.support.AnnotationSupport;

class ExtensionUtils {
    ExtensionUtils() {
    }

    static boolean hasUsePlaywrightAnnotation(ExtensionContext extensionContext) {
        return AnnotationSupport.isAnnotated((Optional)extensionContext.getTestClass(), UsePlaywright.class);
    }

    static UsePlaywright getUsePlaywrightAnnotation(ExtensionContext extensionContext) {
        return (UsePlaywright)AnnotationSupport.findAnnotation((Optional)extensionContext.getTestClass(), UsePlaywright.class).get();
    }

    static boolean isClassHook(ExtensionContext extensionContext) {
        return !extensionContext.getTestMethod().isPresent();
    }

    static boolean isParameterSupported(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> subject) {
        if (!ExtensionUtils.hasUsePlaywrightAnnotation(extensionContext)) {
            return false;
        }
        Class<?> clazz = parameterContext.getParameter().getType();
        return subject.equals(clazz);
    }

    static void setTestIdAttribute(Playwright playwright, Options options) {
        String testIdAttribute = options.testIdAttribute == null ? "data-testid" : options.testIdAttribute;
        playwright.selectors().setTestIdAttribute(testIdAttribute);
    }
}

