/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.junit.impl;

import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.junit.Options;
import com.microsoft.playwright.junit.impl.ExtensionUtils;
import com.microsoft.playwright.junit.impl.OptionsExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class PlaywrightExtension
implements ParameterResolver {
    private static final ThreadLocal<Playwright> threadLocalPlaywright = new ThreadLocal();
    private static final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{PlaywrightExtension.class});

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return ExtensionUtils.isParameterSupported(parameterContext, extensionContext, Playwright.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return PlaywrightExtension.getOrCreatePlaywright(extensionContext);
    }

    static Playwright getOrCreatePlaywright(ExtensionContext extensionContext) {
        Playwright playwright = threadLocalPlaywright.get();
        if (playwright != null) {
            return playwright;
        }
        Options options = OptionsExtension.getOptions(extensionContext);
        PlaywrightRegistry registry = PlaywrightRegistry.getOrCreateFor(extensionContext);
        playwright = registry.createPlaywright(options.playwrightCreateOptions);
        threadLocalPlaywright.set(playwright);
        ExtensionUtils.setTestIdAttribute(playwright, options);
        return playwright;
    }

    static class PlaywrightRegistry
    implements ExtensionContext.Store.CloseableResource {
        private final List<Playwright> playwrightList = Collections.synchronizedList(new ArrayList());

        PlaywrightRegistry() {
        }

        static synchronized PlaywrightRegistry getOrCreateFor(ExtensionContext extensionContext) {
            ExtensionContext.Store rootStore = extensionContext.getRoot().getStore(namespace);
            PlaywrightRegistry instance = (PlaywrightRegistry)rootStore.get(PlaywrightRegistry.class);
            if (instance == null) {
                instance = new PlaywrightRegistry();
                rootStore.put(PlaywrightRegistry.class, (Object)instance);
            }
            return instance;
        }

        Playwright createPlaywright(Playwright.CreateOptions options) {
            Playwright playwright = Playwright.create(options);
            this.playwrightList.add(playwright);
            return playwright;
        }

        public void close() throws Throwable {
            for (Playwright playwright : this.playwrightList) {
                playwright.close();
            }
            this.playwrightList.clear();
        }
    }
}

