/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.impl.AssertionsTimeout;
import com.microsoft.playwright.impl.ExpectedTextValue;
import com.microsoft.playwright.impl.FrameExpectOptions;
import com.microsoft.playwright.impl.FrameExpectResult;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.ValueWrapper;

class AssertionsBase {
    final LocatorImpl actualLocator;
    final boolean isNot;

    AssertionsBase(LocatorImpl actual, boolean isNot) {
        this.actualLocator = actual;
        this.isNot = isNot;
    }

    void expectImpl(String expression, ExpectedTextValue textValue, Object expected, String message, FrameExpectOptions options) {
        this.expectImpl(expression, Arrays.asList(textValue), expected, message, options);
    }

    void expectImpl(String expression, List<ExpectedTextValue> expectedText, Object expected, String message, FrameExpectOptions options) {
        if (options == null) {
            options = new FrameExpectOptions();
        }
        options.expectedText = expectedText;
        options.isNot = this.isNot;
        this.expectImpl(expression, options, expected, message);
    }

    void expectImpl(String expression, FrameExpectOptions expectOptions, Object expected, String message) {
        if (expectOptions.timeout == null) {
            expectOptions.timeout = AssertionsTimeout.defaultTimeout;
        }
        if (expectOptions.isNot) {
            message = message.replace("expected to", "expected not to");
        }
        FrameExpectResult result = this.actualLocator.expect(expression, expectOptions);
        if (result.matches == this.isNot) {
            Object actual = result.received == null ? null : Serialization.deserialize(result.received);
            String log = String.join((CharSequence)"\n", result.log);
            if (!log.isEmpty()) {
                log = "\nCall log:\n" + log;
            }
            if (expected == null) {
                throw new AssertionFailedError(message + log);
            }
            ValueWrapper expectedValue = AssertionsBase.formatValue(expected);
            ValueWrapper actualValue = AssertionsBase.formatValue(actual);
            message = message + ": " + expectedValue.getStringRepresentation() + "\nReceived: " + actualValue.getStringRepresentation() + "\n";
            throw new AssertionFailedError(message + log, (Object)expectedValue, (Object)actualValue);
        }
    }

    private static ValueWrapper formatValue(Object value) {
        if (value == null || !value.getClass().isArray()) {
            return ValueWrapper.create((Object)value);
        }
        Collection values = Arrays.asList((Object[])value).stream().map(e -> e.toString()).collect(Collectors.toList());
        String stringRepresentation = "[" + String.join((CharSequence)", ", values) + "]";
        return ValueWrapper.create((Object)value, (String)stringRepresentation);
    }

    static ExpectedTextValue expectedRegex(Pattern pattern) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.regexSource = pattern.pattern();
        if (pattern.flags() != 0) {
            expected.regexFlags = Utils.toJsRegexFlags(pattern);
        }
        return expected;
    }

    static Boolean shouldIgnoreCase(Object options) {
        if (options == null) {
            return null;
        }
        try {
            Field fromField = options.getClass().getDeclaredField("ignoreCase");
            Object value = fromField.get(options);
            return (Boolean)value;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }
}

