/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.CDPSession;
import com.microsoft.playwright.ConsoleMessage;
import com.microsoft.playwright.Dialog;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.WebError;
import com.microsoft.playwright.impl.APIRequestContextImpl;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.BindingCall;
import com.microsoft.playwright.impl.BrowserImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ConsoleMessageImpl;
import com.microsoft.playwright.impl.DialogImpl;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.HARRouter;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.RequestImpl;
import com.microsoft.playwright.impl.RouteImpl;
import com.microsoft.playwright.impl.Router;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedError;
import com.microsoft.playwright.impl.TargetClosedError;
import com.microsoft.playwright.impl.TimeoutSettings;
import com.microsoft.playwright.impl.TracingImpl;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.WaitableEvent;
import com.microsoft.playwright.impl.WaitablePredicate;
import com.microsoft.playwright.impl.WaitableRace;
import com.microsoft.playwright.impl.WaitableResult;
import com.microsoft.playwright.impl.WebErrorImpl;
import com.microsoft.playwright.impl.WritableStream;
import com.microsoft.playwright.options.BindingCallback;
import com.microsoft.playwright.options.Cookie;
import com.microsoft.playwright.options.FunctionCallback;
import com.microsoft.playwright.options.Geolocation;
import com.microsoft.playwright.options.HarContentPolicy;
import com.microsoft.playwright.options.HarMode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

class BrowserContextImpl
extends ChannelOwner
implements BrowserContext {
    private final BrowserImpl browser;
    private final TracingImpl tracing;
    private final APIRequestContextImpl request;
    final List<PageImpl> pages = new ArrayList<PageImpl>();
    final List<PageImpl> backgroundPages = new ArrayList<PageImpl>();
    final Router routes = new Router();
    private boolean closeWasCalled;
    private final WaitableEvent<EventType, ?> closePromise;
    final Map<String, BindingCallback> bindings = new HashMap<String, BindingCallback>();
    PageImpl ownerPage;
    private String closeReason;
    private final ListenerCollection<EventType> listeners = new ListenerCollection<EventType>(BrowserContextImpl.eventSubscriptions(), this);
    final TimeoutSettings timeoutSettings = new TimeoutSettings();
    Path videosDir;
    URL baseUrl;
    final Map<String, HarRecorder> harRecorders = new HashMap<String, HarRecorder>();

    private static final Map<EventType, String> eventSubscriptions() {
        HashMap<EventType, String> result = new HashMap<EventType, String>();
        result.put(EventType.CONSOLE, "console");
        result.put(EventType.DIALOG, "dialog");
        result.put(EventType.REQUEST, "request");
        result.put(EventType.RESPONSE, "response");
        result.put(EventType.REQUESTFINISHED, "requestFinished");
        result.put(EventType.REQUESTFAILED, "requestFailed");
        return result;
    }

    BrowserContextImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.browser = parent instanceof BrowserImpl ? (BrowserImpl)parent : null;
        this.tracing = (TracingImpl)this.connection.getExistingObject(initializer.getAsJsonObject("tracing").get("guid").getAsString());
        this.request = (APIRequestContextImpl)this.connection.getExistingObject(initializer.getAsJsonObject("requestContext").get("guid").getAsString());
        this.closePromise = new WaitableEvent(this.listeners, EventType.CLOSE);
    }

    void setRecordHar(Path path, HarContentPolicy policy) {
        if (path != null) {
            this.harRecorders.put("", new HarRecorder(path, policy));
        }
    }

    void setBaseUrl(String spec) {
        try {
            this.baseUrl = new URL(spec);
        }
        catch (MalformedURLException e) {
            this.baseUrl = null;
        }
    }

    String effectiveCloseReason() {
        if (this.closeReason != null) {
            return this.closeReason;
        }
        if (this.browser != null) {
            return this.browser.closeReason;
        }
        return null;
    }

    @Override
    public void onBackgroundPage(Consumer<Page> handler) {
        this.listeners.add(EventType.BACKGROUNDPAGE, handler);
    }

    @Override
    public void offBackgroundPage(Consumer<Page> handler) {
        this.listeners.remove(EventType.BACKGROUNDPAGE, handler);
    }

    @Override
    public void onClose(Consumer<BrowserContext> handler) {
        this.listeners.add(EventType.CLOSE, handler);
    }

    @Override
    public void offClose(Consumer<BrowserContext> handler) {
        this.listeners.remove(EventType.CLOSE, handler);
    }

    @Override
    public void onConsoleMessage(Consumer<ConsoleMessage> handler) {
        this.listeners.add(EventType.CONSOLE, handler);
    }

    @Override
    public void offConsoleMessage(Consumer<ConsoleMessage> handler) {
        this.listeners.remove(EventType.CONSOLE, handler);
    }

    @Override
    public void onDialog(Consumer<Dialog> handler) {
        this.listeners.add(EventType.DIALOG, handler);
    }

    @Override
    public void offDialog(Consumer<Dialog> handler) {
        this.listeners.remove(EventType.DIALOG, handler);
    }

    @Override
    public void onPage(Consumer<Page> handler) {
        this.listeners.add(EventType.PAGE, handler);
    }

    @Override
    public void offPage(Consumer<Page> handler) {
        this.listeners.remove(EventType.PAGE, handler);
    }

    @Override
    public void onWebError(Consumer<WebError> handler) {
        this.listeners.add(EventType.WEBERROR, handler);
    }

    @Override
    public void offWebError(Consumer<WebError> handler) {
        this.listeners.remove(EventType.WEBERROR, handler);
    }

    @Override
    public void onRequest(Consumer<Request> handler) {
        this.listeners.add(EventType.REQUEST, handler);
    }

    @Override
    public void offRequest(Consumer<Request> handler) {
        this.listeners.remove(EventType.REQUEST, handler);
    }

    @Override
    public void onRequestFailed(Consumer<Request> handler) {
        this.listeners.add(EventType.REQUESTFAILED, handler);
    }

    @Override
    public void offRequestFailed(Consumer<Request> handler) {
        this.listeners.remove(EventType.REQUESTFAILED, handler);
    }

    @Override
    public void onRequestFinished(Consumer<Request> handler) {
        this.listeners.add(EventType.REQUESTFINISHED, handler);
    }

    @Override
    public void offRequestFinished(Consumer<Request> handler) {
        this.listeners.remove(EventType.REQUESTFINISHED, handler);
    }

    @Override
    public void onResponse(Consumer<Response> handler) {
        this.listeners.add(EventType.RESPONSE, handler);
    }

    @Override
    public void offResponse(Consumer<Response> handler) {
        this.listeners.remove(EventType.RESPONSE, handler);
    }

    private <T> T waitForEventWithTimeout(EventType eventType, Runnable code, Predicate<T> predicate, Double timeout) {
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitableEvent<EventType, T>(this.listeners, eventType, predicate));
        waitables.add(new WaitableContextClose());
        waitables.add(this.timeoutSettings.createWaitable(timeout));
        return this.runUntil(code, new WaitableRace(waitables));
    }

    @Override
    public Page waitForPage(BrowserContext.WaitForPageOptions options, Runnable code) {
        return this.withWaitLogging("BrowserContext.close", logger -> this.waitForPageImpl(options, code));
    }

    private Page waitForPageImpl(BrowserContext.WaitForPageOptions options, Runnable code) {
        if (options == null) {
            options = new BrowserContext.WaitForPageOptions();
        }
        return this.waitForEventWithTimeout(EventType.PAGE, code, options.predicate, options.timeout);
    }

    @Override
    public CDPSession newCDPSession(Page page) {
        JsonObject params = new JsonObject();
        params.add("page", (JsonElement)((PageImpl)page).toProtocolRef());
        JsonObject result = this.sendMessage("newCDPSession", params).getAsJsonObject();
        return (CDPSession)this.connection.getExistingObject(result.getAsJsonObject("session").get("guid").getAsString());
    }

    @Override
    public CDPSession newCDPSession(Frame frame) {
        JsonObject params = new JsonObject();
        params.add("frame", (JsonElement)((FrameImpl)frame).toProtocolRef());
        JsonObject result = this.sendMessage("newCDPSession", params).getAsJsonObject();
        return (CDPSession)this.connection.getExistingObject(result.getAsJsonObject("session").get("guid").getAsString());
    }

    @Override
    public void close(BrowserContext.CloseOptions options) {
        this.withLogging("BrowserContext.close", () -> this.closeImpl(options));
    }

    @Override
    public List<Cookie> cookies(String url) {
        return this.cookies(url == null ? new ArrayList() : Collections.singletonList(url));
    }

    private void closeImpl(BrowserContext.CloseOptions options) {
        if (!this.closeWasCalled) {
            this.closeWasCalled = true;
            if (options == null) {
                options = new BrowserContext.CloseOptions();
            }
            this.closeReason = options.reason;
            for (Map.Entry<String, HarRecorder> entry : this.harRecorders.entrySet()) {
                JsonObject params = new JsonObject();
                params.addProperty("harId", entry.getKey());
                JsonObject json = this.sendMessage("harExport", params).getAsJsonObject();
                ArtifactImpl artifact = (ArtifactImpl)this.connection.getExistingObject(json.getAsJsonObject("artifact").get("guid").getAsString());
                HarRecorder harParams = entry.getValue();
                boolean isCompressed = harParams.contentPolicy == HarContentPolicy.ATTACH || harParams.path.toString().endsWith(".zip");
                boolean needCompressed = harParams.path.toString().endsWith(".zip");
                if (isCompressed && !needCompressed) {
                    String tmpPath = harParams.path + ".tmp";
                    artifact.saveAs(Paths.get(tmpPath, new String[0]));
                    JsonObject unzipParams = new JsonObject();
                    unzipParams.addProperty("zipFile", tmpPath);
                    unzipParams.addProperty("harFile", harParams.path.toString());
                    this.connection.localUtils.sendMessage("harUnzip", unzipParams);
                } else {
                    artifact.saveAs(harParams.path);
                }
                artifact.delete();
            }
            JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
            this.sendMessage("close", params);
        }
        this.runUntil(() -> {}, this.closePromise);
    }

    @Override
    public void addCookies(List<Cookie> cookies) {
        this.withLogging("BrowserContext.addCookies", () -> {
            JsonObject params = new JsonObject();
            params.add("cookies", Serialization.gson().toJsonTree((Object)cookies));
            this.sendMessage("addCookies", params);
        });
    }

    @Override
    public void addInitScript(String script) {
        this.withLogging("BrowserContext.addInitScript", () -> this.addInitScriptImpl(script));
    }

    @Override
    public void addInitScript(Path path) {
        this.withLogging("BrowserContext.addInitScript", () -> {
            try {
                byte[] bytes = Files.readAllBytes(path);
                this.addInitScriptImpl(new String(bytes, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read script from file", e);
            }
        });
    }

    @Override
    public List<Page> backgroundPages() {
        return new ArrayList<Page>(this.backgroundPages);
    }

    private void addInitScriptImpl(String script) {
        JsonObject params = new JsonObject();
        params.addProperty("source", script);
        this.sendMessage("addInitScript", params);
    }

    @Override
    public BrowserImpl browser() {
        return this.browser;
    }

    @Override
    public void clearCookies(BrowserContext.ClearCookiesOptions options) {
        this.withLogging("BrowserContext.clearCookies", () -> this.clearCookiesImpl(options));
    }

    private void clearCookiesImpl(BrowserContext.ClearCookiesOptions options) {
        if (options == null) {
            options = new BrowserContext.ClearCookiesOptions();
        }
        JsonObject params = new JsonObject();
        BrowserContextImpl.setStringOrRegex(params, "name", options.name);
        BrowserContextImpl.setStringOrRegex(params, "domain", options.domain);
        BrowserContextImpl.setStringOrRegex(params, "path", options.path);
        this.sendMessage("clearCookies", params);
    }

    private static void setStringOrRegex(JsonObject params, String name, Object value) {
        if (value instanceof String) {
            params.addProperty(name, (String)value);
        } else if (value instanceof Pattern) {
            Pattern pattern = (Pattern)value;
            params.addProperty(name + "RegexSource", pattern.pattern());
            params.addProperty(name + "RegexFlags", Utils.toJsRegexFlags(pattern));
        }
    }

    @Override
    public void clearPermissions() {
        this.withLogging("BrowserContext.clearPermissions", () -> this.sendMessage("clearPermissions"));
    }

    @Override
    public List<Cookie> cookies(List<String> urls) {
        return this.withLogging("BrowserContext.cookies", () -> this.cookiesImpl(urls));
    }

    private List<Cookie> cookiesImpl(List<String> urls) {
        JsonObject params = new JsonObject();
        if (urls == null) {
            urls = new ArrayList<String>();
        }
        params.add("urls", Serialization.gson().toJsonTree(urls));
        JsonObject json = this.sendMessage("cookies", params).getAsJsonObject();
        Cookie[] cookies = (Cookie[])Serialization.gson().fromJson((JsonElement)json.getAsJsonArray("cookies"), Cookie[].class);
        return Arrays.asList(cookies);
    }

    @Override
    public void exposeBinding(String name, BindingCallback playwrightBinding, BrowserContext.ExposeBindingOptions options) {
        this.withLogging("BrowserContext.exposeBinding", () -> this.exposeBindingImpl(name, playwrightBinding, options));
    }

    private void exposeBindingImpl(String name, BindingCallback playwrightBinding, BrowserContext.ExposeBindingOptions options) {
        if (this.bindings.containsKey(name)) {
            throw new PlaywrightException("Function \"" + name + "\" has been already registered");
        }
        for (PageImpl page : this.pages) {
            if (!page.bindings.containsKey(name)) continue;
            throw new PlaywrightException("Function \"" + name + "\" has been already registered in one of the pages");
        }
        this.bindings.put(name, playwrightBinding);
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        if (options != null && options.handle != null && options.handle.booleanValue()) {
            params.addProperty("needsHandle", Boolean.valueOf(true));
        }
        this.sendMessage("exposeBinding", params);
    }

    @Override
    public void exposeFunction(String name, FunctionCallback playwrightFunction) {
        this.withLogging("BrowserContext.exposeFunction", () -> this.exposeBindingImpl(name, (source, args) -> playwrightFunction.call(args), null));
    }

    @Override
    public void grantPermissions(List<String> permissions, BrowserContext.GrantPermissionsOptions options) {
        this.withLogging("BrowserContext.grantPermissions", () -> this.grantPermissionsImpl(permissions, options));
    }

    private void grantPermissionsImpl(List<String> permissions, BrowserContext.GrantPermissionsOptions options) {
        if (options == null) {
            options = new BrowserContext.GrantPermissionsOptions();
        }
        if (permissions == null) {
            permissions = new ArrayList<String>();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.add("permissions", Serialization.gson().toJsonTree(permissions));
        this.sendMessage("grantPermissions", params);
    }

    @Override
    public PageImpl newPage() {
        return this.withLogging("BrowserContext.newPage", () -> this.newPageImpl());
    }

    private PageImpl newPageImpl() {
        if (this.ownerPage != null) {
            throw new PlaywrightException("Please use browser.newContext()");
        }
        JsonObject json = this.sendMessage("newPage").getAsJsonObject();
        return (PageImpl)this.connection.getExistingObject(json.getAsJsonObject("page").get("guid").getAsString());
    }

    @Override
    public List<Page> pages() {
        return new ArrayList<Page>(this.pages);
    }

    @Override
    public APIRequestContextImpl request() {
        return this.request;
    }

    @Override
    public void route(String url, Consumer<Route> handler, BrowserContext.RouteOptions options) {
        this.route(new UrlMatcher(this.baseUrl, url), handler, options);
    }

    @Override
    public void route(Pattern url, Consumer<Route> handler, BrowserContext.RouteOptions options) {
        this.route(new UrlMatcher(url), handler, options);
    }

    @Override
    public void route(Predicate<String> url, Consumer<Route> handler, BrowserContext.RouteOptions options) {
        this.route(new UrlMatcher(url), handler, options);
    }

    @Override
    public void routeFromHAR(Path har, BrowserContext.RouteFromHAROptions options) {
        if (options == null) {
            options = new BrowserContext.RouteFromHAROptions();
        }
        if (options.update != null && options.update.booleanValue()) {
            this.recordIntoHar(null, har, options);
            return;
        }
        UrlMatcher matcher = UrlMatcher.forOneOf(this.baseUrl, options.url);
        HARRouter harRouter = new HARRouter(this.connection.localUtils, har, options.notFound);
        this.onClose(context -> harRouter.dispose());
        this.route(matcher, (Route route) -> harRouter.handle((Route)route), null);
    }

    private void route(UrlMatcher matcher, Consumer<Route> handler, BrowserContext.RouteOptions options) {
        this.withLogging("BrowserContext.route", () -> {
            this.routes.add(matcher, handler, options == null ? null : options.times);
            this.updateInterceptionPatterns();
        });
    }

    void recordIntoHar(PageImpl page, Path har, BrowserContext.RouteFromHAROptions options) {
        JsonObject params = new JsonObject();
        if (page != null) {
            params.add("page", (JsonElement)page.toProtocolRef());
        }
        JsonObject jsonOptions = new JsonObject();
        jsonOptions.addProperty("path", har.toAbsolutePath().toString());
        jsonOptions.addProperty("content", options.updateContent == null ? HarContentPolicy.ATTACH.name().toLowerCase() : options.updateContent.name().toLowerCase());
        jsonOptions.addProperty("mode", options.updateMode == null ? HarMode.MINIMAL.name().toLowerCase() : options.updateMode.name().toLowerCase());
        Serialization.addHarUrlFilter(jsonOptions, options.url);
        params.add("options", (JsonElement)jsonOptions);
        JsonObject json = this.sendMessage("harStart", params).getAsJsonObject();
        String harId = json.get("harId").getAsString();
        this.harRecorders.put(harId, new HarRecorder(har, HarContentPolicy.ATTACH));
    }

    @Override
    public void setDefaultNavigationTimeout(double timeout) {
        this.setDefaultNavigationTimeoutImpl(timeout);
    }

    void setDefaultNavigationTimeoutImpl(Double timeout) {
        this.withLogging("BrowserContext.setDefaultNavigationTimeout", () -> {
            this.timeoutSettings.setDefaultNavigationTimeout(timeout);
            JsonObject params = new JsonObject();
            params.addProperty("timeout", (Number)timeout);
            this.sendMessage("setDefaultNavigationTimeoutNoReply", params);
        });
    }

    @Override
    public void setDefaultTimeout(double timeout) {
        this.setDefaultTimeoutImpl(timeout);
    }

    void setDefaultTimeoutImpl(Double timeout) {
        this.withLogging("BrowserContext.setDefaultTimeout", () -> {
            this.timeoutSettings.setDefaultTimeout(timeout);
            JsonObject params = new JsonObject();
            params.addProperty("timeout", (Number)timeout);
            this.sendMessage("setDefaultTimeoutNoReply", params);
        });
    }

    @Override
    public void setExtraHTTPHeaders(Map<String, String> headers) {
        this.withLogging("BrowserContext.setExtraHTTPHeaders", () -> {
            JsonObject params = new JsonObject();
            JsonArray jsonHeaders = new JsonArray();
            for (Map.Entry e : headers.entrySet()) {
                JsonObject header = new JsonObject();
                header.addProperty("name", (String)e.getKey());
                header.addProperty("value", (String)e.getValue());
                jsonHeaders.add((JsonElement)header);
            }
            params.add("headers", (JsonElement)jsonHeaders);
            this.sendMessage("setExtraHTTPHeaders", params);
        });
    }

    @Override
    public void setGeolocation(Geolocation geolocation) {
        this.withLogging("BrowserContext.setGeolocation", () -> {
            JsonObject params = new JsonObject();
            if (geolocation != null) {
                params.add("geolocation", Serialization.gson().toJsonTree((Object)geolocation));
            }
            this.sendMessage("setGeolocation", params);
        });
    }

    @Override
    public void setOffline(boolean offline) {
        this.withLogging("BrowserContext.setOffline", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("offline", Boolean.valueOf(offline));
            this.sendMessage("setOffline", params);
        });
    }

    @Override
    public String storageState(BrowserContext.StorageStateOptions options) {
        return this.withLogging("BrowserContext.storageState", () -> {
            JsonElement json = this.sendMessage("storageState");
            String storageState = json.toString();
            if (options != null && options.path != null) {
                Utils.writeToFile(storageState.getBytes(StandardCharsets.UTF_8), options.path);
            }
            return storageState;
        });
    }

    @Override
    public TracingImpl tracing() {
        return this.tracing;
    }

    @Override
    public void unrouteAll() {
        this.withLogging("BrowserContext.unrouteAll", () -> {
            this.routes.removeAll();
            this.updateInterceptionPatterns();
        });
    }

    @Override
    public void unroute(String url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(this.baseUrl, url), handler);
    }

    @Override
    public void unroute(Pattern url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(url), handler);
    }

    @Override
    public void unroute(Predicate<String> url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(url), handler);
    }

    @Override
    public void waitForCondition(BooleanSupplier predicate, BrowserContext.WaitForConditionOptions options) {
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitableContextClose());
        waitables.add(this.timeoutSettings.createWaitable(options == null ? null : options.timeout));
        waitables.add(new WaitablePredicate(predicate));
        this.runUntil(() -> {}, new WaitableRace(waitables));
    }

    @Override
    public ConsoleMessage waitForConsoleMessage(BrowserContext.WaitForConsoleMessageOptions options, Runnable code) {
        return this.withWaitLogging("BrowserContext.waitForConsoleMessage", logger -> this.waitForConsoleMessageImpl(options, code));
    }

    private ConsoleMessage waitForConsoleMessageImpl(BrowserContext.WaitForConsoleMessageOptions options, Runnable code) {
        if (options == null) {
            options = new BrowserContext.WaitForConsoleMessageOptions();
        }
        return this.waitForEventWithTimeout(EventType.CONSOLE, code, options.predicate, options.timeout);
    }

    private void unroute(UrlMatcher matcher, Consumer<Route> handler) {
        this.withLogging("BrowserContext.unroute", () -> {
            this.routes.remove(matcher, handler);
            this.updateInterceptionPatterns();
        });
    }

    private void updateInterceptionPatterns() {
        this.sendMessage("setNetworkInterceptionPatterns", this.routes.interceptionPatterns());
    }

    void handleRoute(RouteImpl route) {
        Router.HandleResult handled = this.routes.handle(route);
        if (handled != Router.HandleResult.NoMatchingHandler) {
            this.updateInterceptionPatterns();
        }
        if (handled == Router.HandleResult.NoMatchingHandler || handled == Router.HandleResult.Fallback) {
            route.resume(null, true);
        }
    }

    WaitableResult<JsonElement> pause() {
        return this.sendMessageAsync("pause", new JsonObject());
    }

    @Override
    protected void handleEvent(String event, JsonObject params) {
        if ("dialog".equals(event)) {
            PageImpl page;
            String guid = params.getAsJsonObject("dialog").get("guid").getAsString();
            DialogImpl dialog = (DialogImpl)this.connection.getExistingObject(guid);
            boolean hasListeners = false;
            if (this.listeners.hasListeners(EventType.DIALOG)) {
                hasListeners = true;
                this.listeners.notify(EventType.DIALOG, dialog);
            }
            if ((page = dialog.page()) != null && page.listeners.hasListeners(PageImpl.EventType.DIALOG)) {
                hasListeners = true;
                page.listeners.notify(PageImpl.EventType.DIALOG, dialog);
            }
            if (!hasListeners) {
                if ("beforeunload".equals(dialog.type())) {
                    try {
                        dialog.accept();
                    }
                    catch (PlaywrightException playwrightException) {}
                } else {
                    dialog.dismiss();
                }
            }
        } else if ("route".equals(event)) {
            RouteImpl route = (RouteImpl)this.connection.getExistingObject(params.getAsJsonObject("route").get("guid").getAsString());
            route.browserContext = this;
            this.handleRoute(route);
        } else if ("page".equals(event)) {
            PageImpl page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
            this.pages.add(page);
            this.listeners.notify(EventType.PAGE, page);
            if (page.opener() != null && !page.opener().isClosed()) {
                page.opener().notifyPopup(page);
            }
        } else if ("backgroundPage".equals(event)) {
            PageImpl page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
            this.backgroundPages.add(page);
            this.listeners.notify(EventType.BACKGROUNDPAGE, page);
        } else if ("bindingCall".equals(event)) {
            BindingCall bindingCall = (BindingCall)this.connection.getExistingObject(params.getAsJsonObject("binding").get("guid").getAsString());
            BindingCallback binding = this.bindings.get(bindingCall.name());
            if (binding != null) {
                bindingCall.call(binding);
            }
        } else if ("console".equals(event)) {
            ConsoleMessageImpl message = new ConsoleMessageImpl(this.connection, params);
            this.listeners.notify(EventType.CONSOLE, message);
            PageImpl page = message.page();
            if (page != null) {
                page.listeners.notify(PageImpl.EventType.CONSOLE, message);
            }
        } else if ("request".equals(event)) {
            String guid = params.getAsJsonObject("request").get("guid").getAsString();
            RequestImpl request = (RequestImpl)this.connection.getExistingObject(guid);
            this.listeners.notify(EventType.REQUEST, request);
            if (params.has("page")) {
                PageImpl page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
                page.listeners.notify(PageImpl.EventType.REQUEST, request);
            }
        } else if ("requestFailed".equals(event)) {
            String guid = params.getAsJsonObject("request").get("guid").getAsString();
            RequestImpl request = (RequestImpl)this.connection.getExistingObject(guid);
            request.didFailOrFinish = true;
            if (params.has("failureText")) {
                request.failure = params.get("failureText").getAsString();
            }
            if (request.timing != null) {
                request.timing.responseEnd = params.get("responseEndTiming").getAsDouble();
            }
            this.listeners.notify(EventType.REQUESTFAILED, request);
            if (params.has("page")) {
                PageImpl page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
                page.listeners.notify(PageImpl.EventType.REQUESTFAILED, request);
            }
        } else if ("requestFinished".equals(event)) {
            String guid = params.getAsJsonObject("request").get("guid").getAsString();
            RequestImpl request = (RequestImpl)this.connection.getExistingObject(guid);
            request.didFailOrFinish = true;
            if (request.timing != null) {
                request.timing.responseEnd = params.get("responseEndTiming").getAsDouble();
            }
            this.listeners.notify(EventType.REQUESTFINISHED, request);
            if (params.has("page")) {
                PageImpl page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
                page.listeners.notify(PageImpl.EventType.REQUESTFINISHED, request);
            }
        } else if ("response".equals(event)) {
            String guid = params.getAsJsonObject("response").get("guid").getAsString();
            Response response = (Response)this.connection.getExistingObject(guid);
            this.listeners.notify(EventType.RESPONSE, response);
            if (params.has("page")) {
                PageImpl page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
                page.listeners.notify(PageImpl.EventType.RESPONSE, response);
            }
        } else if ("pageError".equals(event)) {
            PageImpl page;
            SerializedError error = (SerializedError)Serialization.gson().fromJson((JsonElement)params.getAsJsonObject("error"), SerializedError.class);
            String errorStr = "";
            if (error.error != null) {
                errorStr = error.error.name + ": " + error.error.message;
                if (error.error.stack != null && !error.error.stack.isEmpty()) {
                    errorStr = errorStr + "\n" + error.error.stack;
                }
            }
            try {
                page = (PageImpl)this.connection.getExistingObject(params.getAsJsonObject("page").get("guid").getAsString());
            }
            catch (PlaywrightException e) {
                page = null;
            }
            this.listeners.notify(EventType.WEBERROR, new WebErrorImpl(page, errorStr));
            if (page != null) {
                page.listeners.notify(PageImpl.EventType.PAGEERROR, errorStr);
            }
        } else if ("close".equals(event)) {
            this.didClose();
        }
    }

    void didClose() {
        if (this.browser != null) {
            this.browser.contexts.remove(this);
        }
        this.listeners.notify(EventType.CLOSE, this);
    }

    WritableStream createTempFile(String name, long lastModifiedMs) {
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        params.addProperty("lastModifiedMs", (Number)lastModifiedMs);
        JsonObject json = this.sendMessage("createTempFile", params).getAsJsonObject();
        return (WritableStream)this.connection.getExistingObject(json.getAsJsonObject("writableStream").get("guid").getAsString());
    }

    private class WaitableContextClose<R>
    extends WaitableEvent<EventType, R> {
        WaitableContextClose() {
            super(BrowserContextImpl.this.listeners, EventType.CLOSE);
        }

        @Override
        public R get() {
            throw new TargetClosedError(BrowserContextImpl.this.effectiveCloseReason());
        }
    }

    static enum EventType {
        BACKGROUNDPAGE,
        CLOSE,
        CONSOLE,
        DIALOG,
        PAGE,
        WEBERROR,
        REQUEST,
        REQUESTFAILED,
        REQUESTFINISHED,
        RESPONSE;

    }

    static class HarRecorder {
        final Path path;
        final HarContentPolicy contentPolicy;

        HarRecorder(Path har, HarContentPolicy policy) {
            this.path = har;
            this.contentPolicy = policy;
        }
    }
}

