/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.microsoft.playwright.APIRequest;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Selectors;
import com.microsoft.playwright.impl.APIRequestImpl;
import com.microsoft.playwright.impl.BrowserTypeImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Connection;
import com.microsoft.playwright.impl.PipeTransport;
import com.microsoft.playwright.impl.SelectorsImpl;
import com.microsoft.playwright.impl.SharedSelectors;
import com.microsoft.playwright.impl.driver.Driver;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PlaywrightImpl
extends ChannelOwner
implements Playwright {
    private Process driverProcess;
    private final BrowserTypeImpl chromium;
    private final BrowserTypeImpl firefox;
    private final BrowserTypeImpl webkit;
    private final SelectorsImpl selectors;
    private final APIRequestImpl apiRequest;
    private SharedSelectors sharedSelectors;

    public static PlaywrightImpl create(Playwright.CreateOptions options) {
        return PlaywrightImpl.createImpl(options, false);
    }

    public static PlaywrightImpl createImpl(Playwright.CreateOptions options, boolean forceNewDriverInstanceForTests) {
        Map<String, String> env = Collections.emptyMap();
        if (options != null && options.env != null) {
            env = options.env;
        }
        Driver driver = forceNewDriverInstanceForTests ? Driver.createAndInstall(env, (Boolean)true) : Driver.ensureDriverInstalled(env, (Boolean)true);
        try {
            ProcessBuilder pb = driver.createProcessBuilder();
            pb.command().add("run-driver");
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            Connection connection = new Connection(new PipeTransport(p.getInputStream(), p.getOutputStream()), env);
            PlaywrightImpl result = connection.initializePlaywright();
            result.driverProcess = p;
            result.initSharedSelectors(null);
            return result;
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to launch driver", e);
        }
    }

    PlaywrightImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.chromium = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("chromium").get("guid").getAsString());
        this.firefox = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("firefox").get("guid").getAsString());
        this.webkit = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("webkit").get("guid").getAsString());
        this.selectors = (SelectorsImpl)this.connection.getExistingObject(initializer.getAsJsonObject("selectors").get("guid").getAsString());
        this.apiRequest = new APIRequestImpl(this);
    }

    void initSharedSelectors(PlaywrightImpl parent) {
        assert (this.sharedSelectors == null);
        this.sharedSelectors = parent == null ? new SharedSelectors() : parent.sharedSelectors;
        this.sharedSelectors.addChannel(this.selectors);
    }

    void unregisterSelectors() {
        this.sharedSelectors.removeChannel(this.selectors);
    }

    public JsonArray deviceDescriptors() {
        return this.connection.localUtils.deviceDescriptors();
    }

    @Override
    public BrowserTypeImpl chromium() {
        return this.chromium;
    }

    @Override
    public BrowserTypeImpl firefox() {
        return this.firefox;
    }

    @Override
    public APIRequest request() {
        return this.apiRequest;
    }

    @Override
    public BrowserTypeImpl webkit() {
        return this.webkit;
    }

    @Override
    public Selectors selectors() {
        return this.sharedSelectors;
    }

    @Override
    public void close() {
        try {
            this.connection.close();
            boolean didClose = this.driverProcess.waitFor(30L, TimeUnit.SECONDS);
            if (!didClose) {
                System.err.println("WARNING: Timed out while waiting for driver process to exit");
            }
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to terminate", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlaywrightException("Operation interrupted", e);
        }
    }
}

