/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.options.BindingCallback;
import java.util.ArrayList;

class BindingCall
extends ChannelOwner {
    BindingCall(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    String name() {
        return this.initializer.get("name").getAsString();
    }

    void call(BindingCallback binding) {
        try {
            Frame frame = (Frame)this.connection.getExistingObject(this.initializer.getAsJsonObject("frame").get("guid").getAsString());
            SourceImpl source = new SourceImpl(frame);
            ArrayList<Object> args = new ArrayList<Object>();
            if (this.initializer.has("handle")) {
                JSHandle handle = (JSHandle)this.connection.getExistingObject(this.initializer.getAsJsonObject("handle").get("guid").getAsString());
                args.add(handle);
            } else {
                for (JsonElement arg : this.initializer.getAsJsonArray("args")) {
                    args.add(Serialization.deserialize((SerializedValue)Serialization.gson().fromJson(arg, SerializedValue.class)));
                }
            }
            Object result = binding.call(source, args.toArray());
            JsonObject params = new JsonObject();
            params.add("result", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(result)));
            this.sendMessage("resolve", params);
        }
        catch (RuntimeException exception) {
            JsonObject params = new JsonObject();
            params.add("error", Serialization.gson().toJsonTree((Object)Serialization.serializeError(exception)));
            this.sendMessage("reject", params);
        }
    }

    private static class SourceImpl
    implements BindingCallback.Source {
        private final Frame frame;

        public SourceImpl(Frame frame) {
            this.frame = frame;
        }

        @Override
        public BrowserContext context() {
            return this.page().context();
        }

        @Override
        public Page page() {
            return this.frame.page();
        }

        @Override
        public Frame frame() {
            return this.frame;
        }
    }
}

