/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.TimeoutError;
import com.microsoft.playwright.impl.APIRequestContextImpl;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.BindingCall;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.BrowserImpl;
import com.microsoft.playwright.impl.BrowserTypeImpl;
import com.microsoft.playwright.impl.CDPSessionImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.DialogImpl;
import com.microsoft.playwright.impl.DriverException;
import com.microsoft.playwright.impl.ElementHandleImpl;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.JSHandleImpl;
import com.microsoft.playwright.impl.JsonPipe;
import com.microsoft.playwright.impl.LocalUtils;
import com.microsoft.playwright.impl.Message;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.PlaywrightImpl;
import com.microsoft.playwright.impl.RequestImpl;
import com.microsoft.playwright.impl.ResponseImpl;
import com.microsoft.playwright.impl.RouteImpl;
import com.microsoft.playwright.impl.SelectorsImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.StackTraceCollector;
import com.microsoft.playwright.impl.Stream;
import com.microsoft.playwright.impl.TargetClosedError;
import com.microsoft.playwright.impl.TracingImpl;
import com.microsoft.playwright.impl.Transport;
import com.microsoft.playwright.impl.TransportLogger;
import com.microsoft.playwright.impl.WaitableResult;
import com.microsoft.playwright.impl.WebSocketImpl;
import com.microsoft.playwright.impl.WorkerImpl;
import com.microsoft.playwright.impl.WritableStream;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Connection {
    private final Transport transport;
    private final Map<String, ChannelOwner> objects = new HashMap<String, ChannelOwner>();
    private final Root root;
    final boolean isRemote;
    private int lastId = 0;
    private final StackTraceCollector stackTraceCollector;
    private final Map<Integer, WaitableResult<JsonElement>> callbacks = new HashMap<Integer, WaitableResult<JsonElement>>();
    private String apiName;
    private static final boolean isLogging;
    LocalUtils localUtils;
    PlaywrightImpl playwright;
    final Map<String, String> env;
    private int tracingCount;

    Connection(Transport pipe, Map<String, String> env, LocalUtils localUtils) {
        this(pipe, env, true);
        this.localUtils = localUtils;
    }

    Connection(Transport transport, Map<String, String> env) {
        this(transport, env, false);
    }

    private Connection(Transport transport, Map<String, String> env, boolean isRemote) {
        this.env = env;
        this.isRemote = isRemote;
        if (isLogging) {
            transport = new TransportLogger(transport);
        }
        this.transport = transport;
        this.root = new Root(this);
        this.stackTraceCollector = StackTraceCollector.createFromEnv(env);
    }

    void setIsTracing(boolean tracing) {
        this.tracingCount = tracing ? ++this.tracingCount : --this.tracingCount;
    }

    String setApiName(String name) {
        String previous = this.apiName;
        this.apiName = name;
        return previous;
    }

    void close() throws IOException {
        this.transport.close();
    }

    public JsonElement sendMessage(String guid, String method, JsonObject params) {
        return this.root.runUntil(() -> {}, this.sendMessageAsync(guid, method, params));
    }

    public WaitableResult<JsonElement> sendMessageAsync(String guid, String method, JsonObject params) {
        return this.internalSendMessage(guid, method, params, true);
    }

    private WaitableResult<JsonElement> internalSendMessage(String guid, String method, JsonObject params, boolean sendStack) {
        int id = ++this.lastId;
        WaitableResult<JsonElement> result = new WaitableResult<JsonElement>();
        this.callbacks.put(id, result);
        JsonObject message = new JsonObject();
        message.addProperty("id", (Number)id);
        message.addProperty("guid", guid);
        message.addProperty("method", method);
        message.add("params", (JsonElement)params);
        JsonObject metadata = new JsonObject();
        metadata.addProperty("wallTime", (Number)System.currentTimeMillis());
        JsonArray stack = null;
        if (this.apiName == null) {
            metadata.addProperty("internal", Boolean.valueOf(true));
        } else {
            metadata.addProperty("apiName", this.apiName);
            this.apiName = null;
            if (this.stackTraceCollector != null && !(stack = this.stackTraceCollector.currentStackTrace()).isEmpty()) {
                JsonObject location = new JsonObject();
                JsonObject frame = stack.get(0).getAsJsonObject();
                location.addProperty("file", frame.get("file").getAsString());
                location.addProperty("line", (Number)frame.get("line").getAsInt());
                location.addProperty("column", (Number)frame.get("column").getAsInt());
                metadata.add("location", (JsonElement)location);
            }
        }
        message.add("metadata", (JsonElement)metadata);
        this.transport.send(message);
        if (sendStack && this.tracingCount > 0 && stack != null && !method.startsWith("LocalUtils")) {
            JsonObject callData = new JsonObject();
            callData.addProperty("id", (Number)id);
            callData.add("stack", (JsonElement)stack);
            JsonObject stackParams = new JsonObject();
            stackParams.add("callData", (JsonElement)callData);
            this.internalSendMessage(this.localUtils.guid, "addStackToTracingNoReply", stackParams, false);
        }
        return result;
    }

    public PlaywrightImpl initializePlaywright() {
        this.playwright = this.root.initialize();
        return this.playwright;
    }

    LocalUtils localUtils() {
        return this.localUtils;
    }

    public <T> T getExistingObject(String guid) {
        ChannelOwner result = this.objects.get(guid);
        if (result == null) {
            throw new PlaywrightException("Object doesn't exist: " + guid);
        }
        return (T)result;
    }

    void registerObject(String guid, ChannelOwner object) {
        this.objects.put(guid, object);
    }

    void unregisterObject(String guid) {
        this.objects.remove(guid);
    }

    void processOneMessage() {
        JsonObject message = this.transport.poll(Duration.ofMillis(10L));
        if (message == null) {
            return;
        }
        Gson gson = Serialization.gson();
        Message messageObj = (Message)gson.fromJson((JsonElement)message, Message.class);
        this.dispatch(messageObj);
    }

    private static String formatCallLog(JsonArray log) {
        if (log == null) {
            return "";
        }
        boolean allEmpty = true;
        for (JsonElement e : log) {
            if (e.getAsString().isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add("Call log:");
        for (JsonElement e : log) {
            lines.add("- " + e.getAsString());
        }
        lines.add("");
        return String.join((CharSequence)"\n", lines);
    }

    private void dispatch(Message message) {
        if (message.id != 0) {
            WaitableResult<JsonElement> callback = this.callbacks.get(message.id);
            if (callback == null) {
                throw new PlaywrightException("Cannot find command to respond: " + message.id);
            }
            this.callbacks.remove(message.id);
            if (message.error == null) {
                callback.complete(message.result);
            } else {
                String callLog = Connection.formatCallLog(message.log);
                if (message.error.error == null) {
                    callback.completeExceptionally(new PlaywrightException(message.error + callLog));
                } else if ("TimeoutError".equals(message.error.error.name)) {
                    callback.completeExceptionally(new TimeoutError(message.error.error + callLog));
                } else if ("TargetClosedError".equals(message.error.error.name)) {
                    callback.completeExceptionally(new TargetClosedError(message.error.error + callLog));
                } else {
                    callback.completeExceptionally(new DriverException(message.error.error + callLog));
                }
            }
            return;
        }
        if (message.method == null) {
            return;
        }
        if (message.method.equals("__create__")) {
            this.createRemoteObject(message.guid, message.params);
            return;
        }
        ChannelOwner object = this.objects.get(message.guid);
        if (object == null) {
            throw new PlaywrightException("Cannot find object to call " + message.method + ": " + message.guid);
        }
        if (message.method.equals("__adopt__")) {
            String childGuid = message.params.get("guid").getAsString();
            ChannelOwner child = this.objects.get(childGuid);
            if (child == null) {
                throw new PlaywrightException("Unknown new child:  " + childGuid);
            }
            object.adopt(child);
            return;
        }
        if (message.method.equals("__dispose__")) {
            boolean wasCollected = message.params.has("reason") && "gc".equals(message.params.get("reason").getAsString());
            object.disposeChannelOwner(wasCollected);
            return;
        }
        object.handleEvent(message.method, message.params);
    }

    private ChannelOwner createRemoteObject(String parentGuid, JsonObject params) {
        String type = params.get("type").getAsString();
        String guid = params.get("guid").getAsString();
        ChannelOwner parent = this.objects.get(parentGuid);
        if (parent == null) {
            throw new PlaywrightException("Cannot find parent object " + parentGuid + " to create " + guid);
        }
        JsonObject initializer = params.getAsJsonObject("initializer");
        ChannelOwner result = null;
        switch (type) {
            case "Android": {
                break;
            }
            case "AndroidSocket": {
                break;
            }
            case "AndroidDevice": {
                break;
            }
            case "Artifact": {
                result = new ArtifactImpl(parent, type, guid, initializer);
                break;
            }
            case "BindingCall": {
                result = new BindingCall(parent, type, guid, initializer);
                break;
            }
            case "BrowserType": {
                result = new BrowserTypeImpl(parent, type, guid, initializer);
                break;
            }
            case "Browser": {
                result = new BrowserImpl(parent, type, guid, initializer);
                break;
            }
            case "BrowserContext": {
                result = new BrowserContextImpl(parent, type, guid, initializer);
                break;
            }
            case "Dialog": {
                result = new DialogImpl(parent, type, guid, initializer);
                break;
            }
            case "Electron": {
                break;
            }
            case "ElementHandle": {
                result = new ElementHandleImpl(parent, type, guid, initializer);
                break;
            }
            case "APIRequestContext": {
                result = new APIRequestContextImpl(parent, type, guid, initializer);
                break;
            }
            case "Frame": {
                result = new FrameImpl(parent, type, guid, initializer);
                break;
            }
            case "JSHandle": {
                result = new JSHandleImpl(parent, type, guid, initializer);
                break;
            }
            case "JsonPipe": {
                result = new JsonPipe(parent, type, guid, initializer);
                break;
            }
            case "LocalUtils": {
                result = new LocalUtils(parent, type, guid, initializer);
                if (this.localUtils != null) break;
                this.localUtils = (LocalUtils)result;
                break;
            }
            case "Page": {
                result = new PageImpl(parent, type, guid, initializer);
                break;
            }
            case "Playwright": {
                result = new PlaywrightImpl(parent, type, guid, initializer);
                break;
            }
            case "Request": {
                result = new RequestImpl(parent, type, guid, initializer);
                break;
            }
            case "Response": {
                result = new ResponseImpl(parent, type, guid, initializer);
                break;
            }
            case "Route": {
                result = new RouteImpl(parent, type, guid, initializer);
                break;
            }
            case "Stream": {
                result = new Stream(parent, type, guid, initializer);
                break;
            }
            case "Selectors": {
                result = new SelectorsImpl(parent, type, guid, initializer);
                break;
            }
            case "SocksSupport": {
                break;
            }
            case "Tracing": {
                result = new TracingImpl(parent, type, guid, initializer);
                break;
            }
            case "WebSocket": {
                result = new WebSocketImpl(parent, type, guid, initializer);
                break;
            }
            case "Worker": {
                result = new WorkerImpl(parent, type, guid, initializer);
                break;
            }
            case "WritableStream": {
                result = new WritableStream(parent, type, guid, initializer);
                break;
            }
            case "CDPSession": {
                result = new CDPSessionImpl(parent, type, guid, initializer);
                break;
            }
            default: {
                throw new PlaywrightException("Unknown type " + type);
            }
        }
        return result;
    }

    static {
        String debug = System.getenv("DEBUG");
        isLogging = debug != null && debug.contains("pw:channel");
    }

    class Root
    extends ChannelOwner {
        Root(Connection connection) {
            super(connection, "Root", "");
        }

        PlaywrightImpl initialize() {
            JsonObject params = new JsonObject();
            params.addProperty("sdkLanguage", "java");
            JsonElement result = this.sendMessage("initialize", params.getAsJsonObject());
            return (PlaywrightImpl)this.connection.getExistingObject(result.getAsJsonObject().getAsJsonObject("playwright").get("guid").getAsString());
        }
    }
}

