/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.RawHeaders;
import com.microsoft.playwright.impl.RequestImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.WaitableNever;
import com.microsoft.playwright.impl.WaitableRace;
import com.microsoft.playwright.options.HttpHeader;
import com.microsoft.playwright.options.SecurityDetails;
import com.microsoft.playwright.options.ServerAddr;
import com.microsoft.playwright.options.Timing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class ResponseImpl
extends ChannelOwner
implements Response {
    private final RawHeaders headers;
    private RawHeaders rawHeaders;
    private final RequestImpl request;

    ResponseImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.headers = new RawHeaders(Arrays.asList((HttpHeader[])Serialization.gson().fromJson((JsonElement)initializer.getAsJsonArray("headers"), HttpHeader[].class)));
        this.request = (RequestImpl)this.connection.getExistingObject(initializer.getAsJsonObject("request").get("guid").getAsString());
        this.request.timing = (Timing)Serialization.gson().fromJson(initializer.get("timing"), Timing.class);
    }

    @Override
    public Map<String, String> allHeaders() {
        return this.withLogging("Response.allHeaders", () -> this.getRawHeaders().headers());
    }

    @Override
    public byte[] body() {
        return this.withLogging("Response.body", () -> {
            JsonObject json = this.sendMessage("body").getAsJsonObject();
            return Base64.getDecoder().decode(json.get("binary").getAsString());
        });
    }

    @Override
    public String finished() {
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitableNever<String>(){

            @Override
            public boolean isDone() {
                return ((ResponseImpl)ResponseImpl.this).request.didFailOrFinish;
            }

            @Override
            public String get() {
                return ResponseImpl.this.request.failure();
            }
        });
        PageImpl page = this.request.frame().page;
        waitables.add(page.createWaitForCloseHelper());
        waitables.add(page.createWaitableTimeout(null));
        this.runUntil(() -> {}, new WaitableRace(waitables));
        return this.request.failure();
    }

    @Override
    public Frame frame() {
        return this.request().frame();
    }

    @Override
    public boolean fromServiceWorker() {
        return this.initializer.get("fromServiceWorker").getAsBoolean();
    }

    @Override
    public Map<String, String> headers() {
        return this.headers.headers();
    }

    @Override
    public List<HttpHeader> headersArray() {
        return this.withLogging("Response.headersArray", () -> this.getRawHeaders().headersArray());
    }

    @Override
    public String headerValue(String name) {
        return this.getRawHeaders().get(name);
    }

    @Override
    public List<String> headerValues(String name) {
        return this.getRawHeaders().getAll(name);
    }

    @Override
    public boolean ok() {
        return this.status() == 0 || this.status() >= 200 && this.status() <= 299;
    }

    @Override
    public RequestImpl request() {
        return this.request;
    }

    @Override
    public SecurityDetails securityDetails() {
        return this.withLogging("Response.securityDetails", () -> {
            JsonObject json = this.sendMessage("securityDetails").getAsJsonObject();
            if (json.has("value")) {
                return (SecurityDetails)Serialization.gson().fromJson(json.get("value"), SecurityDetails.class);
            }
            return null;
        });
    }

    @Override
    public ServerAddr serverAddr() {
        return this.withLogging("Response.serverAddr", () -> {
            JsonObject json = this.sendMessage("serverAddr").getAsJsonObject();
            if (json.has("value")) {
                return (ServerAddr)Serialization.gson().fromJson(json.get("value"), ServerAddr.class);
            }
            return null;
        });
    }

    @Override
    public int status() {
        return this.initializer.get("status").getAsInt();
    }

    @Override
    public String statusText() {
        return this.initializer.get("statusText").getAsString();
    }

    @Override
    public String text() {
        return new String(this.body(), StandardCharsets.UTF_8);
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    private RawHeaders getRawHeaders() {
        if (this.rawHeaders == null) {
            JsonObject json = this.sendMessage("rawResponseHeaders").getAsJsonObject();
            this.rawHeaders = new RawHeaders(Arrays.asList((HttpHeader[])Serialization.gson().fromJson((JsonElement)json.getAsJsonArray("headers"), HttpHeader[].class)));
        }
        return this.rawHeaders;
    }
}

