/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Tracing;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import java.nio.file.Path;

class TracingImpl
extends ChannelOwner
implements Tracing {
    private boolean includeSources;
    private Path tracesDir;
    private boolean isTracing;
    private String stacksId;

    TracingImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    private void stopChunkImpl(Path path) {
        boolean isLocal;
        if (this.isTracing) {
            this.isTracing = false;
            this.connection.setIsTracing(false);
        }
        JsonObject params = new JsonObject();
        if (path == null) {
            params.addProperty("mode", "discard");
            this.sendMessage("tracingStopChunk", params);
            if (this.stacksId != null) {
                this.connection.localUtils().traceDiscarded(this.stacksId);
            }
            return;
        }
        boolean bl = isLocal = !this.connection.isRemote;
        if (isLocal) {
            params.addProperty("mode", "entries");
            JsonObject json = this.sendMessage("tracingStopChunk", params).getAsJsonObject();
            JsonArray entries = json.getAsJsonArray("entries");
            this.connection.localUtils.zip(path, entries, this.stacksId, false, this.includeSources);
            return;
        }
        params.addProperty("mode", "archive");
        JsonObject json = this.sendMessage("tracingStopChunk", params).getAsJsonObject();
        if (!json.has("artifact")) {
            if (this.stacksId != null) {
                this.connection.localUtils().traceDiscarded(this.stacksId);
            }
            return;
        }
        ArtifactImpl artifact = (ArtifactImpl)this.connection.getExistingObject(json.getAsJsonObject("artifact").get("guid").getAsString());
        artifact.saveAs(path);
        artifact.delete();
        this.connection.localUtils.zip(path, new JsonArray(), this.stacksId, true, this.includeSources);
    }

    @Override
    public void startChunk(Tracing.StartChunkOptions options) {
        if (options == null) {
            options = new Tracing.StartChunkOptions();
        }
        this.tracingStartChunk(options.name, options.title);
    }

    private void tracingStartChunk(String name, String title) {
        JsonObject params = new JsonObject();
        if (name != null) {
            params.addProperty("name", name);
        }
        if (title != null) {
            params.addProperty("title", title);
        }
        JsonObject result = this.sendMessage("tracingStartChunk", params).getAsJsonObject();
        this.startCollectingStacks(result.get("traceName").getAsString());
    }

    private void startCollectingStacks(String traceName) {
        if (!this.isTracing) {
            this.isTracing = true;
            this.connection.setIsTracing(true);
        }
        this.stacksId = this.connection.localUtils().tracingStarted(this.tracesDir == null ? null : this.tracesDir.toString(), traceName);
    }

    @Override
    public void start(Tracing.StartOptions options) {
        if (options == null) {
            options = new Tracing.StartOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        boolean bl = this.includeSources = options.sources != null && options.sources != false;
        if (this.includeSources) {
            params.addProperty("sources", Boolean.valueOf(true));
        }
        this.sendMessage("tracingStart", params);
        this.tracingStartChunk(options.name, options.title);
    }

    @Override
    public void stop(Tracing.StopOptions options) {
        this.stopChunkImpl(options == null ? null : options.path);
        this.sendMessage("tracingStop");
    }

    @Override
    public void stopChunk(Tracing.StopChunkOptions options) {
        this.stopChunkImpl(options == null ? null : options.path);
    }

    void setTracesDir(Path tracesDir) {
        this.tracesDir = tracesDir;
    }
}

