/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.options.BrowserChannel;
import com.microsoft.playwright.options.ColorScheme;
import com.microsoft.playwright.options.ForcedColors;
import com.microsoft.playwright.options.Geolocation;
import com.microsoft.playwright.options.HarContentPolicy;
import com.microsoft.playwright.options.HarMode;
import com.microsoft.playwright.options.HttpCredentials;
import com.microsoft.playwright.options.Proxy;
import com.microsoft.playwright.options.RecordVideoSize;
import com.microsoft.playwright.options.ReducedMotion;
import com.microsoft.playwright.options.ScreenSize;
import com.microsoft.playwright.options.ServiceWorkerPolicy;
import com.microsoft.playwright.options.ViewportSize;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public interface BrowserType {
    default public Browser connect(String wsEndpoint) {
        return this.connect(wsEndpoint, null);
    }

    public Browser connect(String var1, ConnectOptions var2);

    default public Browser connectOverCDP(String endpointURL) {
        return this.connectOverCDP(endpointURL, null);
    }

    public Browser connectOverCDP(String var1, ConnectOverCDPOptions var2);

    public String executablePath();

    default public Browser launch() {
        return this.launch(null);
    }

    public Browser launch(LaunchOptions var1);

    default public BrowserContext launchPersistentContext(Path userDataDir) {
        return this.launchPersistentContext(userDataDir, null);
    }

    public BrowserContext launchPersistentContext(Path var1, LaunchPersistentContextOptions var2);

    public String name();

    public static class LaunchPersistentContextOptions {
        public Boolean acceptDownloads;
        public List<String> args;
        public String baseURL;
        public Boolean bypassCSP;
        public Object channel;
        public Boolean chromiumSandbox;
        public Optional<ColorScheme> colorScheme;
        public Double deviceScaleFactor;
        public Boolean devtools;
        public Path downloadsPath;
        public Map<String, String> env;
        public Path executablePath;
        public Map<String, String> extraHTTPHeaders;
        public Map<String, Object> firefoxUserPrefs;
        public Optional<ForcedColors> forcedColors;
        public Geolocation geolocation;
        public Boolean handleSIGHUP;
        public Boolean handleSIGINT;
        public Boolean handleSIGTERM;
        public Boolean hasTouch;
        public Boolean headless;
        public HttpCredentials httpCredentials;
        public Boolean ignoreAllDefaultArgs;
        public List<String> ignoreDefaultArgs;
        public Boolean ignoreHTTPSErrors;
        public Boolean isMobile;
        public Boolean javaScriptEnabled;
        public String locale;
        public Boolean offline;
        public List<String> permissions;
        public Proxy proxy;
        public HarContentPolicy recordHarContent;
        public HarMode recordHarMode;
        public Boolean recordHarOmitContent;
        public Path recordHarPath;
        public Object recordHarUrlFilter;
        public Path recordVideoDir;
        public RecordVideoSize recordVideoSize;
        public Optional<ReducedMotion> reducedMotion;
        public ScreenSize screenSize;
        public ServiceWorkerPolicy serviceWorkers;
        public Double slowMo;
        public Boolean strictSelectors;
        public Double timeout;
        public String timezoneId;
        public Path tracesDir;
        public String userAgent;
        public Optional<ViewportSize> viewportSize;

        public LaunchPersistentContextOptions setAcceptDownloads(boolean acceptDownloads) {
            this.acceptDownloads = acceptDownloads;
            return this;
        }

        public LaunchPersistentContextOptions setArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public LaunchPersistentContextOptions setBaseURL(String baseURL) {
            this.baseURL = baseURL;
            return this;
        }

        public LaunchPersistentContextOptions setBypassCSP(boolean bypassCSP) {
            this.bypassCSP = bypassCSP;
            return this;
        }

        @Deprecated
        public LaunchPersistentContextOptions setChannel(BrowserChannel channel) {
            this.channel = channel;
            return this;
        }

        public LaunchPersistentContextOptions setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public LaunchPersistentContextOptions setChromiumSandbox(boolean chromiumSandbox) {
            this.chromiumSandbox = chromiumSandbox;
            return this;
        }

        public LaunchPersistentContextOptions setColorScheme(ColorScheme colorScheme) {
            this.colorScheme = Optional.ofNullable(colorScheme);
            return this;
        }

        public LaunchPersistentContextOptions setDeviceScaleFactor(double deviceScaleFactor) {
            this.deviceScaleFactor = deviceScaleFactor;
            return this;
        }

        public LaunchPersistentContextOptions setDevtools(boolean devtools) {
            this.devtools = devtools;
            return this;
        }

        public LaunchPersistentContextOptions setDownloadsPath(Path downloadsPath) {
            this.downloadsPath = downloadsPath;
            return this;
        }

        public LaunchPersistentContextOptions setEnv(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public LaunchPersistentContextOptions setExecutablePath(Path executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public LaunchPersistentContextOptions setExtraHTTPHeaders(Map<String, String> extraHTTPHeaders) {
            this.extraHTTPHeaders = extraHTTPHeaders;
            return this;
        }

        public LaunchPersistentContextOptions setFirefoxUserPrefs(Map<String, Object> firefoxUserPrefs) {
            this.firefoxUserPrefs = firefoxUserPrefs;
            return this;
        }

        public LaunchPersistentContextOptions setForcedColors(ForcedColors forcedColors) {
            this.forcedColors = Optional.ofNullable(forcedColors);
            return this;
        }

        public LaunchPersistentContextOptions setGeolocation(double latitude, double longitude) {
            return this.setGeolocation(new Geolocation(latitude, longitude));
        }

        public LaunchPersistentContextOptions setGeolocation(Geolocation geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        public LaunchPersistentContextOptions setHandleSIGHUP(boolean handleSIGHUP) {
            this.handleSIGHUP = handleSIGHUP;
            return this;
        }

        public LaunchPersistentContextOptions setHandleSIGINT(boolean handleSIGINT) {
            this.handleSIGINT = handleSIGINT;
            return this;
        }

        public LaunchPersistentContextOptions setHandleSIGTERM(boolean handleSIGTERM) {
            this.handleSIGTERM = handleSIGTERM;
            return this;
        }

        public LaunchPersistentContextOptions setHasTouch(boolean hasTouch) {
            this.hasTouch = hasTouch;
            return this;
        }

        public LaunchPersistentContextOptions setHeadless(boolean headless) {
            this.headless = headless;
            return this;
        }

        public LaunchPersistentContextOptions setHttpCredentials(String username, String password) {
            return this.setHttpCredentials(new HttpCredentials(username, password));
        }

        public LaunchPersistentContextOptions setHttpCredentials(HttpCredentials httpCredentials) {
            this.httpCredentials = httpCredentials;
            return this;
        }

        public LaunchPersistentContextOptions setIgnoreAllDefaultArgs(boolean ignoreAllDefaultArgs) {
            this.ignoreAllDefaultArgs = ignoreAllDefaultArgs;
            return this;
        }

        public LaunchPersistentContextOptions setIgnoreDefaultArgs(List<String> ignoreDefaultArgs) {
            this.ignoreDefaultArgs = ignoreDefaultArgs;
            return this;
        }

        public LaunchPersistentContextOptions setIgnoreHTTPSErrors(boolean ignoreHTTPSErrors) {
            this.ignoreHTTPSErrors = ignoreHTTPSErrors;
            return this;
        }

        public LaunchPersistentContextOptions setIsMobile(boolean isMobile) {
            this.isMobile = isMobile;
            return this;
        }

        public LaunchPersistentContextOptions setJavaScriptEnabled(boolean javaScriptEnabled) {
            this.javaScriptEnabled = javaScriptEnabled;
            return this;
        }

        public LaunchPersistentContextOptions setLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public LaunchPersistentContextOptions setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public LaunchPersistentContextOptions setPermissions(List<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public LaunchPersistentContextOptions setProxy(String server) {
            return this.setProxy(new Proxy(server));
        }

        public LaunchPersistentContextOptions setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public LaunchPersistentContextOptions setRecordHarContent(HarContentPolicy recordHarContent) {
            this.recordHarContent = recordHarContent;
            return this;
        }

        public LaunchPersistentContextOptions setRecordHarMode(HarMode recordHarMode) {
            this.recordHarMode = recordHarMode;
            return this;
        }

        public LaunchPersistentContextOptions setRecordHarOmitContent(boolean recordHarOmitContent) {
            this.recordHarOmitContent = recordHarOmitContent;
            return this;
        }

        public LaunchPersistentContextOptions setRecordHarPath(Path recordHarPath) {
            this.recordHarPath = recordHarPath;
            return this;
        }

        public LaunchPersistentContextOptions setRecordHarUrlFilter(String recordHarUrlFilter) {
            this.recordHarUrlFilter = recordHarUrlFilter;
            return this;
        }

        public LaunchPersistentContextOptions setRecordHarUrlFilter(Pattern recordHarUrlFilter) {
            this.recordHarUrlFilter = recordHarUrlFilter;
            return this;
        }

        public LaunchPersistentContextOptions setRecordVideoDir(Path recordVideoDir) {
            this.recordVideoDir = recordVideoDir;
            return this;
        }

        public LaunchPersistentContextOptions setRecordVideoSize(int width, int height) {
            return this.setRecordVideoSize(new RecordVideoSize(width, height));
        }

        public LaunchPersistentContextOptions setRecordVideoSize(RecordVideoSize recordVideoSize) {
            this.recordVideoSize = recordVideoSize;
            return this;
        }

        public LaunchPersistentContextOptions setReducedMotion(ReducedMotion reducedMotion) {
            this.reducedMotion = Optional.ofNullable(reducedMotion);
            return this;
        }

        public LaunchPersistentContextOptions setScreenSize(int width, int height) {
            return this.setScreenSize(new ScreenSize(width, height));
        }

        public LaunchPersistentContextOptions setScreenSize(ScreenSize screenSize) {
            this.screenSize = screenSize;
            return this;
        }

        public LaunchPersistentContextOptions setServiceWorkers(ServiceWorkerPolicy serviceWorkers) {
            this.serviceWorkers = serviceWorkers;
            return this;
        }

        public LaunchPersistentContextOptions setSlowMo(double slowMo) {
            this.slowMo = slowMo;
            return this;
        }

        public LaunchPersistentContextOptions setStrictSelectors(boolean strictSelectors) {
            this.strictSelectors = strictSelectors;
            return this;
        }

        public LaunchPersistentContextOptions setTimeout(double timeout) {
            this.timeout = timeout;
            return this;
        }

        public LaunchPersistentContextOptions setTimezoneId(String timezoneId) {
            this.timezoneId = timezoneId;
            return this;
        }

        public LaunchPersistentContextOptions setTracesDir(Path tracesDir) {
            this.tracesDir = tracesDir;
            return this;
        }

        public LaunchPersistentContextOptions setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public LaunchPersistentContextOptions setViewportSize(int width, int height) {
            return this.setViewportSize(new ViewportSize(width, height));
        }

        public LaunchPersistentContextOptions setViewportSize(ViewportSize viewportSize) {
            this.viewportSize = Optional.ofNullable(viewportSize);
            return this;
        }
    }

    public static class LaunchOptions {
        public List<String> args;
        public Object channel;
        public Boolean chromiumSandbox;
        public Boolean devtools;
        public Path downloadsPath;
        public Map<String, String> env;
        public Path executablePath;
        public Map<String, Object> firefoxUserPrefs;
        public Boolean handleSIGHUP;
        public Boolean handleSIGINT;
        public Boolean handleSIGTERM;
        public Boolean headless;
        public Boolean ignoreAllDefaultArgs;
        public List<String> ignoreDefaultArgs;
        public Proxy proxy;
        public Double slowMo;
        public Double timeout;
        public Path tracesDir;

        public LaunchOptions setArgs(List<String> args) {
            this.args = args;
            return this;
        }

        @Deprecated
        public LaunchOptions setChannel(BrowserChannel channel) {
            this.channel = channel;
            return this;
        }

        public LaunchOptions setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public LaunchOptions setChromiumSandbox(boolean chromiumSandbox) {
            this.chromiumSandbox = chromiumSandbox;
            return this;
        }

        public LaunchOptions setDevtools(boolean devtools) {
            this.devtools = devtools;
            return this;
        }

        public LaunchOptions setDownloadsPath(Path downloadsPath) {
            this.downloadsPath = downloadsPath;
            return this;
        }

        public LaunchOptions setEnv(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public LaunchOptions setExecutablePath(Path executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public LaunchOptions setFirefoxUserPrefs(Map<String, Object> firefoxUserPrefs) {
            this.firefoxUserPrefs = firefoxUserPrefs;
            return this;
        }

        public LaunchOptions setHandleSIGHUP(boolean handleSIGHUP) {
            this.handleSIGHUP = handleSIGHUP;
            return this;
        }

        public LaunchOptions setHandleSIGINT(boolean handleSIGINT) {
            this.handleSIGINT = handleSIGINT;
            return this;
        }

        public LaunchOptions setHandleSIGTERM(boolean handleSIGTERM) {
            this.handleSIGTERM = handleSIGTERM;
            return this;
        }

        public LaunchOptions setHeadless(boolean headless) {
            this.headless = headless;
            return this;
        }

        public LaunchOptions setIgnoreAllDefaultArgs(boolean ignoreAllDefaultArgs) {
            this.ignoreAllDefaultArgs = ignoreAllDefaultArgs;
            return this;
        }

        public LaunchOptions setIgnoreDefaultArgs(List<String> ignoreDefaultArgs) {
            this.ignoreDefaultArgs = ignoreDefaultArgs;
            return this;
        }

        public LaunchOptions setProxy(String server) {
            return this.setProxy(new Proxy(server));
        }

        public LaunchOptions setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public LaunchOptions setSlowMo(double slowMo) {
            this.slowMo = slowMo;
            return this;
        }

        public LaunchOptions setTimeout(double timeout) {
            this.timeout = timeout;
            return this;
        }

        public LaunchOptions setTracesDir(Path tracesDir) {
            this.tracesDir = tracesDir;
            return this;
        }
    }

    public static class ConnectOverCDPOptions {
        public Map<String, String> headers;
        public Double slowMo;
        public Double timeout;

        public ConnectOverCDPOptions setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public ConnectOverCDPOptions setSlowMo(double slowMo) {
            this.slowMo = slowMo;
            return this;
        }

        public ConnectOverCDPOptions setTimeout(double timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    public static class ConnectOptions {
        public String exposeNetwork;
        public Map<String, String> headers;
        public Double slowMo;
        public Double timeout;

        public ConnectOptions setExposeNetwork(String exposeNetwork) {
            this.exposeNetwork = exposeNetwork;
            return this;
        }

        public ConnectOptions setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public ConnectOptions setSlowMo(double slowMo) {
            this.slowMo = slowMo;
            return this;
        }

        public ConnectOptions setTimeout(double timeout) {
            this.timeout = timeout;
            return this;
        }
    }
}

