/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.FrameLocator;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.LocatorUtils;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.AriaRole;
import java.util.regex.Pattern;

class FrameLocatorImpl
implements FrameLocator {
    private final FrameImpl frame;
    private final String frameSelector;

    FrameLocatorImpl(FrameImpl frame, String selector) {
        this.frame = frame;
        this.frameSelector = selector;
    }

    @Override
    public FrameLocator first() {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> nth=0");
    }

    @Override
    public FrameLocatorImpl frameLocator(String selector) {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> internal:control=enter-frame >> " + selector);
    }

    @Override
    public Locator getByAltText(String text, FrameLocator.GetByAltTextOptions options) {
        return this.locator(LocatorUtils.getByAltTextSelector(text, Utils.convertType(options, Locator.GetByAltTextOptions.class)));
    }

    @Override
    public Locator getByAltText(Pattern text, FrameLocator.GetByAltTextOptions options) {
        return this.locator(LocatorUtils.getByAltTextSelector(text, Utils.convertType(options, Locator.GetByAltTextOptions.class)));
    }

    @Override
    public Locator getByLabel(String text, FrameLocator.GetByLabelOptions options) {
        return this.locator(LocatorUtils.getByLabelSelector(text, Utils.convertType(options, Locator.GetByLabelOptions.class)));
    }

    @Override
    public Locator getByLabel(Pattern text, FrameLocator.GetByLabelOptions options) {
        return this.locator(LocatorUtils.getByLabelSelector(text, Utils.convertType(options, Locator.GetByLabelOptions.class)));
    }

    @Override
    public Locator getByPlaceholder(String text, FrameLocator.GetByPlaceholderOptions options) {
        return this.locator(LocatorUtils.getByPlaceholderSelector(text, Utils.convertType(options, Locator.GetByPlaceholderOptions.class)));
    }

    @Override
    public Locator getByPlaceholder(Pattern text, FrameLocator.GetByPlaceholderOptions options) {
        return this.locator(LocatorUtils.getByPlaceholderSelector(text, Utils.convertType(options, Locator.GetByPlaceholderOptions.class)));
    }

    @Override
    public Locator getByRole(AriaRole role, FrameLocator.GetByRoleOptions options) {
        return this.locator(LocatorUtils.getByRoleSelector(role, Utils.convertType(options, Locator.GetByRoleOptions.class)));
    }

    @Override
    public Locator getByTestId(String testId) {
        return this.locator(LocatorUtils.getByTestIdSelector(testId, this.frame.connection.playwright));
    }

    @Override
    public Locator getByTestId(Pattern testId) {
        return this.locator(LocatorUtils.getByTestIdSelector(testId, this.frame.connection.playwright));
    }

    @Override
    public Locator getByText(String text, FrameLocator.GetByTextOptions options) {
        return this.locator(LocatorUtils.getByTextSelector(text, Utils.convertType(options, Locator.GetByTextOptions.class)));
    }

    @Override
    public Locator getByText(Pattern text, FrameLocator.GetByTextOptions options) {
        return this.locator(LocatorUtils.getByTextSelector(text, Utils.convertType(options, Locator.GetByTextOptions.class)));
    }

    @Override
    public Locator getByTitle(String text, FrameLocator.GetByTitleOptions options) {
        return this.locator(LocatorUtils.getByTitleSelector(text, Utils.convertType(options, Locator.GetByTitleOptions.class)));
    }

    @Override
    public Locator getByTitle(Pattern text, FrameLocator.GetByTitleOptions options) {
        return this.locator(LocatorUtils.getByTitleSelector(text, Utils.convertType(options, Locator.GetByTitleOptions.class)));
    }

    @Override
    public FrameLocator last() {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> nth=-1");
    }

    @Override
    public Locator locator(String selector, FrameLocator.LocatorOptions options) {
        return new LocatorImpl(this.frame, this.frameSelector + " >> internal:control=enter-frame >> " + selector, Utils.convertType(options, Locator.LocatorOptions.class));
    }

    @Override
    public Locator locator(Locator selectorOrLocator, FrameLocator.LocatorOptions options) {
        LocatorImpl other = (LocatorImpl)selectorOrLocator;
        if (other.frame != this.frame) {
            throw new PlaywrightException("Locators must belong to the same frame.");
        }
        return this.locator(other.selector, options);
    }

    @Override
    public FrameLocator nth(int index) {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> nth=" + index);
    }

    @Override
    public Locator owner() {
        return new LocatorImpl(this.frame, this.frameSelector);
    }
}

